/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.Set;
import org.apache.accumulo.core.client.impl.ThriftTransportPool;
import org.apache.accumulo.fate.zookeeper.ZooSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUp {
    private static final Logger log = LoggerFactory.getLogger(CleanUp.class);

    public static void shutdownNow() {
        ThriftTransportPool.getInstance().shutdown();
        ZooSession.shutdown();
        CleanUp.waitForZooKeeperClientThreads();
    }

    private static void waitForZooKeeperClientThreads() {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread thread : threadSet) {
            if (!thread.getClass().getName().startsWith("org.apache.zookeeper.ClientCnxn") || !thread.getContextClassLoader().equals(Thread.currentThread().getContextClassLoader())) continue;
            while (thread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }
}

