/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc.saml;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.net.URI;

public interface IJdbcBrowserClient
extends Closeable {
    public void startListening() throws HiveJdbcBrowserException;

    public void doBrowserSSO() throws HiveJdbcBrowserException;

    public void init(JdbcBrowserClientContext var1);

    public Integer getPort();

    public HiveJdbcBrowserServerResponse getServerResponse();

    public String getClientIdentifier();

    public static class HiveJdbcBrowserServerResponse {
        private final String msg;
        private final boolean status;
        private final String token;

        public HiveJdbcBrowserServerResponse(boolean status, String msg, String token) {
            this.status = status;
            this.msg = msg;
            this.token = token;
        }

        public String getMsg() {
            return this.msg;
        }

        public boolean isSuccessful() {
            return this.status;
        }

        public String getToken() {
            return this.token;
        }

        public boolean isValid() {
            return !this.status || this.token != null && !this.token.isEmpty();
        }
    }

    public static class HiveJdbcBrowserException
    extends Exception {
        HiveJdbcBrowserException(String msg, Throwable ex) {
            super(msg, ex);
        }

        HiveJdbcBrowserException(String msg) {
            super(msg);
        }

        HiveJdbcBrowserException(Throwable e) {
            super(e);
        }
    }

    public static class JdbcBrowserClientContext {
        private final URI ssoUri;
        private final String clientIdentifier;

        JdbcBrowserClientContext(URI ssoUrl, String clientIdentifier) {
            this.ssoUri = (URI)Preconditions.checkNotNull((Object)ssoUrl);
            this.clientIdentifier = (String)Preconditions.checkNotNull((Object)clientIdentifier);
        }

        public URI getSsoUri() {
            return this.ssoUri;
        }

        public String getClientIdentifier() {
            return this.clientIdentifier;
        }
    }
}

