/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.esriJson;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UnenclosedBaseJsonRecordReader
extends RecordReader<LongWritable, Text>
implements org.apache.hadoop.mapred.RecordReader<LongWritable, Text> {
    static final Logger LOG = LoggerFactory.getLogger((String)UnenclosedBaseJsonRecordReader.class.getName());
    protected BufferedReader inputReader;
    protected LongWritable mkey = null;
    protected Text mval = null;
    protected long readerPosition;
    protected long start;
    protected long end;
    protected boolean firstBraceConsumed = false;

    protected UnenclosedBaseJsonRecordReader() throws IOException {
        this.mkey = this.createKey();
        this.mval = this.createValue();
    }

    protected UnenclosedBaseJsonRecordReader(org.apache.hadoop.mapred.InputSplit split, Configuration conf) throws IOException {
        org.apache.hadoop.mapred.FileSplit fileSplit = (org.apache.hadoop.mapred.FileSplit)split;
        this.start = fileSplit.getStart();
        this.end = fileSplit.getLength() + this.start;
        Path filePath = fileSplit.getPath();
        this.commonInit(filePath, conf);
    }

    public void close() throws IOException {
        if (this.inputReader != null) {
            this.inputReader.close();
        }
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public Text createValue() {
        return new Text();
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.mkey;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.mval;
    }

    public long getPos() throws IOException {
        return this.readerPosition;
    }

    public float getProgress() throws IOException {
        return (float)(this.readerPosition - this.start) / (float)(this.end - this.start);
    }

    public void initialize(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)split;
        this.start = fileSplit.getStart();
        this.end = fileSplit.getLength() + this.start;
        Path filePath = fileSplit.getPath();
        this.commonInit(filePath, taskContext.getConfiguration());
    }

    public boolean next(LongWritable key, Text value) throws IOException {
        int chr = 0;
        int brace_depth = 0;
        char lit_char = '\u0000';
        boolean first_brace_found = false;
        if (!this.firstBraceConsumed) {
            chr = this.getNonWhite();
            this.firstBraceConsumed = chr == 123;
        }
        if (this.readerPosition + (long)(this.firstBraceConsumed ? 0 : 1) > this.end) {
            return false;
        }
        StringBuilder sb = new StringBuilder(2000);
        if (this.firstBraceConsumed) {
            brace_depth = 1;
            sb.append("{");
            first_brace_found = true;
            this.firstBraceConsumed = false;
            key.set(this.readerPosition - 1L);
        }
        boolean inEscape = false;
        while (brace_depth > 0 || !first_brace_found) {
            chr = this.getChar();
            if (chr < 0) {
                if (first_brace_found) {
                    LOG.error("Parsing error : EOF occurred before record ended");
                }
                return false;
            }
            switch (chr) {
                case 92: {
                    inEscape = lit_char != '\u0000' && !inEscape;
                    break;
                }
                case 34: 
                case 39: {
                    if (lit_char == '\u0000') {
                        lit_char = (char)chr;
                        break;
                    }
                    if (inEscape) {
                        inEscape = false;
                        break;
                    }
                    if (lit_char != chr) break;
                    lit_char = '\u0000';
                    break;
                }
                case 123: {
                    if (inEscape) {
                        inEscape = false;
                        break;
                    }
                    if (lit_char != '\u0000') break;
                    ++brace_depth;
                    if (first_brace_found) break;
                    first_brace_found = true;
                    key.set(this.readerPosition - 1L);
                    break;
                }
                case 125: {
                    if (inEscape) {
                        inEscape = false;
                        break;
                    }
                    if (lit_char != '\u0000') break;
                    --brace_depth;
                    break;
                }
                default: {
                    inEscape = false;
                }
            }
            if (brace_depth < 0) {
                LOG.error("Parsing error : no '{' - unmatched '}' in record");
                return false;
            }
            if (!first_brace_found) continue;
            sb.append((char)chr);
        }
        if (!first_brace_found) {
            return false;
        }
        value.set(sb.toString());
        return true;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.next(this.mkey, this.mval);
    }

    private void commonInit(Path filePath, Configuration conf) throws IOException {
        this.readerPosition = this.start;
        FileSystem fs = filePath.getFileSystem(conf);
        this.inputReader = new BufferedReader(new InputStreamReader((InputStream)fs.open(filePath)));
        if (this.start != 0L) {
            this.inputReader.skip(this.start);
            this.moveToRecordStart();
        }
    }

    protected int getChar() throws IOException {
        int ch = this.inputReader.read();
        ++this.readerPosition;
        return ch;
    }

    protected int getNonWhite() throws IOException {
        int ch;
        while (Character.isWhitespace((char)(ch = this.getChar()))) {
        }
        return ch;
    }

    protected abstract boolean moveToRecordStart() throws IOException;
}

