/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.NamedJoinInfo;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RowSchema rowSchema = new RowSchema();
    private Map<String, Map<String, ColumnInfo>> rslvMap = new LinkedHashMap<String, Map<String, ColumnInfo>>();
    private HashMap<String, String[]> invRslvMap = new HashMap();
    private final Map<String, String[]> altInvRslvMap = new HashMap<String, String[]>();
    private Map<String, ASTNode> expressionMap = new HashMap<String, ASTNode>();
    private Map<String, Map<String, String>> ambiguousColumns = new LinkedHashMap<String, Map<String, String>>();
    private boolean checkForAmbiguity = false;
    private boolean isExprResolver = false;
    private static final Logger LOG = LoggerFactory.getLogger((String)RowResolver.class.getName());
    private NamedJoinInfo namedJoinInfo;

    public void putExpression(ASTNode node, ColumnInfo colInfo) {
        String treeAsString = node.toStringTree();
        this.expressionMap.put(treeAsString, node);
        if (!this.putInternal("", treeAsString, colInfo)) {
            return;
        }
        colInfo.setAlias(treeAsString);
    }

    public ColumnInfo getExpression(ASTNode node) throws SemanticException {
        return this.get("", node.toStringTree());
    }

    public ASTNode getExpressionSource(ASTNode node) {
        return this.expressionMap.get(node.toStringTree());
    }

    public void put(String tabAlias, String colAlias, ColumnInfo colInfo) {
        if (!this.putInternal(tabAlias, colAlias, colInfo)) {
            return;
        }
        if (colAlias != null) {
            colInfo.setAlias(colAlias.toLowerCase());
        }
    }

    private boolean putInternal(String tabAlias, String colAlias, ColumnInfo colInfo) {
        if (!this.addMappingOnly(tabAlias, colAlias, colInfo)) {
            if (tabAlias != null) {
                colInfo.setTabAlias(tabAlias.toLowerCase());
            }
            this.rowSchema.getSignature().add(colInfo);
            return true;
        }
        return false;
    }

    public void putAll(Map<ASTNode, String> exprToColumnAlias) throws SemanticException {
        for (ASTNode astNode : exprToColumnAlias.keySet()) {
            if (this.getExpression(astNode) == null) continue;
            this.put("", exprToColumnAlias.get(astNode), this.getExpression(astNode));
        }
    }

    private void keepAmbiguousInfo(String col_alias, String tab_alias) {
        Map<String, String> colAliases = this.ambiguousColumns.get(tab_alias);
        if (colAliases == null) {
            colAliases = new LinkedHashMap<String, String>();
            this.ambiguousColumns.put(tab_alias, colAliases);
        }
        colAliases.put(col_alias, col_alias);
    }

    public boolean addMappingOnly(String tab_alias, String col_alias, ColumnInfo colInfo) {
        ColumnInfo oldColInfo;
        if (tab_alias != null) {
            tab_alias = tab_alias.toLowerCase();
        }
        boolean colPresent = this.invRslvMap.containsKey(colInfo.getInternalName());
        Map<String, ColumnInfo> f_map = this.rslvMap.get(tab_alias);
        if (f_map == null) {
            f_map = new LinkedHashMap<String, ColumnInfo>();
            this.rslvMap.put(tab_alias, f_map);
        }
        if ((oldColInfo = f_map.put(col_alias, colInfo)) != null) {
            LOG.warn("Duplicate column info for " + tab_alias + "." + col_alias + " was overwritten in RowResolver map: " + String.valueOf(oldColInfo) + " by " + String.valueOf(colInfo));
            this.keepAmbiguousInfo(col_alias, tab_alias);
        }
        String[] qualifiedAlias = new String[]{tab_alias, col_alias};
        if (!colPresent) {
            this.invRslvMap.put(colInfo.getInternalName(), qualifiedAlias);
        } else {
            this.altInvRslvMap.put(colInfo.getInternalName(), qualifiedAlias);
        }
        return colPresent;
    }

    public boolean hasTableAlias(String tab_alias) {
        return this.rslvMap.get(tab_alias.toLowerCase()) != null;
    }

    public ColumnInfo get(String tab_alias, String col_alias) throws SemanticException {
        ColumnInfo ret = null;
        if (!this.isExprResolver && this.isAmbiguousReference(tab_alias, col_alias)) {
            String tableName = tab_alias != null ? tab_alias : "";
            String fullQualifiedName = tableName + "." + col_alias;
            throw new SemanticException("Ambiguous column reference: " + fullQualifiedName);
        }
        if (tab_alias != null) {
            Map<String, ColumnInfo> f_map = this.rslvMap.get(tab_alias = tab_alias.toLowerCase());
            if (f_map == null) {
                return null;
            }
            ret = f_map.get(col_alias);
        } else {
            boolean found = false;
            String foundTbl = null;
            for (Map.Entry<String, Map<String, ColumnInfo>> rslvEntry : this.rslvMap.entrySet()) {
                String rslvKey = rslvEntry.getKey();
                Map<String, ColumnInfo> cmap = rslvEntry.getValue();
                for (Map.Entry<String, ColumnInfo> cmapEnt : cmap.entrySet()) {
                    if (!col_alias.equalsIgnoreCase(cmapEnt.getKey())) continue;
                    if (found && foundTbl != null && rslvKey != null) {
                        throw new SemanticException("Column " + col_alias + " Found in more than One Tables/Subqueries");
                    }
                    found = true;
                    foundTbl = rslvKey == null ? foundTbl : rslvKey;
                    ret = cmapEnt.getValue();
                }
            }
        }
        return ret;
    }

    public List<ColumnInfo> getColumnInfos() {
        return this.rowSchema.getSignature();
    }

    public List<String> getReferenceableColumnAliases(String tableAlias, int max) {
        int count = 0;
        LinkedHashSet<Object> columnNames = new LinkedHashSet<Object>();
        int tables = this.rslvMap.size();
        Map<String, ColumnInfo> mapping = this.rslvMap.get(tableAlias);
        if (mapping != null) {
            for (Map.Entry<String, ColumnInfo> entry : mapping.entrySet()) {
                if (max <= 0 || count < max) {
                    ColumnInfo columnInfo = entry.getValue();
                    if (columnInfo.isHiddenVirtualCol()) continue;
                    columnNames.add(entry.getKey());
                    ++count;
                    continue;
                }
                break;
            }
        } else {
            for (ColumnInfo columnInfo : this.getColumnInfos()) {
                if (max <= 0 || count < max) {
                    String[] inverse;
                    if (columnInfo.isHiddenVirtualCol()) continue;
                    String[] stringArray = inverse = !this.isExprResolver ? this.reverseLookup(columnInfo.getInternalName()) : null;
                    if (inverse != null) {
                        columnNames.add(inverse[0] == null || tables <= 1 ? inverse[1] : inverse[0] + "." + inverse[1]);
                    } else {
                        columnNames.add(columnInfo.getAlias());
                    }
                    ++count;
                    continue;
                }
                break;
            }
        }
        return new ArrayList<String>(columnNames);
    }

    public Map<String, ColumnInfo> getFieldMap(String tabAlias) {
        if (tabAlias == null) {
            return this.rslvMap.get(null);
        }
        return this.rslvMap.get(tabAlias.toLowerCase());
    }

    public int getPosition(String internalName) {
        int pos = -1;
        for (ColumnInfo var : this.rowSchema.getSignature()) {
            ++pos;
            if (!var.getInternalName().equals(internalName)) continue;
            return pos;
        }
        return -1;
    }

    public Set<String> getTableNames() {
        return this.rslvMap.keySet();
    }

    public String getTableAliasContainingColumn(String columnName) {
        String result = null;
        for (Map.Entry<String, Map<String, ColumnInfo>> entry : this.rslvMap.entrySet()) {
            if (!entry.getValue().containsKey(columnName)) continue;
            result = entry.getKey();
        }
        return result;
    }

    public String[] reverseLookup(String internalName) {
        return this.invRslvMap.get(internalName);
    }

    public void setIsExprResolver(boolean isExprResolver) {
        this.isExprResolver = isExprResolver;
    }

    public boolean getIsExprResolver() {
        return this.isExprResolver;
    }

    public String[] getAlternateMappings(String internalName) {
        return this.altInvRslvMap.get(internalName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<String, ColumnInfo>> e : this.rslvMap.entrySet()) {
            String tab = e.getKey();
            sb.append(tab + "{");
            Map<String, ColumnInfo> f_map = e.getValue();
            if (f_map != null) {
                for (Map.Entry<String, ColumnInfo> entry : f_map.entrySet()) {
                    sb.append("(" + entry.getKey() + "," + entry.getValue().toString() + ")");
                }
            }
            sb.append("} ");
        }
        return sb.toString();
    }

    public RowSchema getRowSchema() {
        return this.rowSchema;
    }

    public Map<String, Map<String, ColumnInfo>> getRslvMap() {
        return this.rslvMap;
    }

    public Map<String, ASTNode> getExpressionMap() {
        return this.expressionMap;
    }

    public void setExprResolver(boolean isExprResolver) {
        this.isExprResolver = isExprResolver;
    }

    public boolean doesInvRslvMapContain(String column) {
        return this.getInvRslvMap().containsKey(column);
    }

    public void setRowSchema(RowSchema rowSchema) {
        this.rowSchema = rowSchema;
    }

    public void setExpressionMap(Map<String, ASTNode> expressionMap) {
        this.expressionMap = expressionMap;
    }

    public static boolean add(RowResolver rrToAddTo, RowResolver rrToAddFrom, int numColumns) throws SemanticException {
        return RowResolver.add(rrToAddTo, rrToAddFrom, null, numColumns);
    }

    private static boolean add(RowResolver rrToAddTo, RowResolver rrToAddFrom, IntRef outputColPosRef, int numColumns) throws SemanticException {
        boolean hasDuplicates = false;
        int i = 0;
        int outputColPos = outputColPosRef == null ? 0 : outputColPosRef.val;
        for (ColumnInfo cInfoFrmInput : rrToAddFrom.getRowSchema().getSignature()) {
            if (numColumns >= 0 && i == numColumns) break;
            ColumnInfo newCI = null;
            String internalName = cInfoFrmInput.getInternalName();
            String[] qualifiedColName = rrToAddFrom.reverseLookup(internalName);
            String tabAlias = qualifiedColName[0];
            String colAlias = qualifiedColName[1];
            newCI = new ColumnInfo(cInfoFrmInput);
            newCI.setInternalName(SemanticAnalyzer.getColumnInternalName(outputColPos));
            ++outputColPos;
            boolean isUnique = rrToAddTo.putWithCheck(tabAlias, colAlias, internalName, newCI);
            hasDuplicates |= !isUnique;
            qualifiedColName = rrToAddFrom.getAlternateMappings(internalName);
            if (qualifiedColName != null) {
                tabAlias = qualifiedColName[0];
                colAlias = qualifiedColName[1];
                rrToAddTo.put(tabAlias, colAlias, newCI);
            }
            ++i;
        }
        if (outputColPosRef != null) {
            outputColPosRef.val = outputColPos;
        }
        return !hasDuplicates;
    }

    public boolean putWithCheck(String tabAlias, String colAlias, String internalName, ColumnInfo newCI) throws SemanticException {
        ColumnInfo existing = this.get(tabAlias, colAlias);
        if (existing == null) {
            this.put(tabAlias, colAlias, newCI);
            return true;
        }
        if (existing.isSameColumnForRR(newCI)) {
            return true;
        }
        LOG.warn("Found duplicate column alias in RR: " + existing.toMappingString(tabAlias, colAlias) + " adding " + newCI.toMappingString(tabAlias, colAlias));
        if (internalName != null) {
            existing = this.get(tabAlias, internalName);
            if (existing == null) {
                this.keepAmbiguousInfo(colAlias, tabAlias);
                this.put(tabAlias, internalName, newCI);
                return true;
            }
            if (existing.isSameColumnForRR(newCI)) {
                return true;
            }
            LOG.warn("Failed to use internal name after finding a duplicate: " + existing.toMappingString(tabAlias, internalName));
        }
        return false;
    }

    private static boolean add(RowResolver rrToAddTo, RowResolver rrToAddFrom, IntRef outputColPosRef) throws SemanticException {
        return RowResolver.add(rrToAddTo, rrToAddFrom, outputColPosRef, -1);
    }

    public static boolean add(RowResolver rrToAddTo, RowResolver rrToAddFrom) throws SemanticException {
        return RowResolver.add(rrToAddTo, rrToAddFrom, null, -1);
    }

    public static RowResolver getCombinedRR(RowResolver leftRR, RowResolver rightRR) throws SemanticException {
        RowResolver combinedRR = new RowResolver();
        IntRef outputColPos = new IntRef();
        if (!RowResolver.add(combinedRR, leftRR, outputColPos)) {
            LOG.warn("Duplicates detected when adding columns to RR: see previous message");
        }
        if (!RowResolver.add(combinedRR, rightRR, outputColPos)) {
            LOG.warn("Duplicates detected when adding columns to RR: see previous message");
        }
        return combinedRR;
    }

    public RowResolver duplicate() {
        RowResolver resolver = new RowResolver();
        resolver.rowSchema = new RowSchema(this.rowSchema);
        for (Map.Entry<String, Map<String, ColumnInfo>> entry : this.rslvMap.entrySet()) {
            resolver.rslvMap.put(entry.getKey(), new LinkedHashMap<String, ColumnInfo>(entry.getValue()));
        }
        resolver.invRslvMap.putAll(this.invRslvMap);
        resolver.altInvRslvMap.putAll(this.altInvRslvMap);
        resolver.expressionMap.putAll(this.expressionMap);
        resolver.isExprResolver = this.isExprResolver;
        for (Map.Entry<String, Map<String, Object>> entry : this.ambiguousColumns.entrySet()) {
            resolver.ambiguousColumns.put(entry.getKey(), new LinkedHashMap<String, Object>(entry.getValue()));
        }
        resolver.ambiguousColumns.putAll(this.ambiguousColumns);
        resolver.checkForAmbiguity = this.checkForAmbiguity;
        return resolver;
    }

    private HashMap<String, String[]> getInvRslvMap() {
        return this.invRslvMap;
    }

    public NamedJoinInfo getNamedJoinInfo() {
        return this.namedJoinInfo;
    }

    public void setNamedJoinInfo(NamedJoinInfo namedJoinInfo) {
        this.namedJoinInfo = namedJoinInfo;
    }

    private boolean isAmbiguousReference(String tableAlias, String colAlias) {
        if (!this.getCheckForAmbiguity()) {
            return false;
        }
        if (this.ambiguousColumns == null || this.ambiguousColumns.isEmpty()) {
            return false;
        }
        if (tableAlias != null) {
            Map<String, String> colAliases = this.ambiguousColumns.get(tableAlias.toLowerCase());
            if (colAliases != null && colAliases.containsKey(colAlias.toLowerCase())) {
                return true;
            }
        } else {
            for (Map.Entry<String, Map<String, String>> ambiguousColsEntry : this.ambiguousColumns.entrySet()) {
                Map<String, String> cmap = ambiguousColsEntry.getValue();
                for (Map.Entry<String, String> cmapEnt : cmap.entrySet()) {
                    if (!colAlias.equalsIgnoreCase(cmapEnt.getKey())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setCheckForAmbiguity(boolean check) {
        this.checkForAmbiguity = check;
    }

    public boolean getCheckForAmbiguity() {
        return this.checkForAmbiguity;
    }

    private static class IntRef {
        public int val = 0;

        private IntRef() {
        }
    }
}

