/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;

public enum HiveOperation {
    EXPLAIN("EXPLAIN", 1025, null, null),
    LOAD("LOAD", 1090, null, new Privilege[]{Privilege.ALTER_DATA}),
    EXPORT("EXPORT", 1028, new Privilege[]{Privilege.SELECT}, null),
    IMPORT("IMPORT", 1057, null, new Privilege[]{Privilege.ALTER_METADATA, Privilege.ALTER_DATA}),
    REPLDUMP("REPLDUMP", 1174, new Privilege[]{Privilege.ALL}, null),
    REPLLOAD("REPLLOAD", 1175, null, new Privilege[]{Privilege.ALL}),
    REPLSTATUS("REPLSTATUS", 1176, new Privilege[]{Privilege.SELECT}, null),
    CREATECATALOG("CREATECATALOG", 955, null, new Privilege[]{Privilege.CREATE}),
    DROPCATALOG("DROPCATALOG", 1004, null, new Privilege[]{Privilege.DROP}),
    CREATEDATABASE("CREATEDATABASE", 956, null, new Privilege[]{Privilege.CREATE}),
    CREATEDATACONNECTOR("CREATEDATACONNECTOR", 957, null, new Privilege[]{Privilege.CREATE}),
    DROPDATABASE("DROPDATABASE", 1005, null, new Privilege[]{Privilege.DROP}),
    DROPDATACONNECTOR("DROPDATACONNECTOR", 1006, null, new Privilege[]{Privilege.DROP}),
    SWITCHDATABASE("SWITCHDATABASE", 1248, null, null, true, false),
    LOCKDB("LOCKDATABASE", 1091, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKDB("UNLOCKDATABASE", 1307, new Privilege[]{Privilege.LOCK}, null),
    DROPTABLE("DROPTABLE", 1010, null, new Privilege[]{Privilege.DROP}),
    DESCTABLE("DESCTABLE", 997, null, null),
    DESCFUNCTION("DESCFUNCTION", 996, null, null),
    MSCK("MSCK", 1098, null, null),
    ALTERTABLE_ADDCOLS("ALTERTABLE_ADDCOLS", 864, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_DROPCOL("ALTERTABLE_DROPCOL", 875, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_REPLACECOLS("ALTERTABLE_REPLACECOLS", 893, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMECOL("ALTERTABLE_RENAMECOL", 890, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMEPART("ALTERTABLE_RENAMEPART", 891, new Privilege[]{Privilege.DROP}, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_UPDATEPARTSTATS("ALTERTABLE_UPDATEPARTSTATS", new int[]{862, 861}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATETABLESTATS("ALTERTABLE_UPDATETABLESTATS", new int[]{905, 903}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAME("ALTERTABLE_RENAME", 889, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_DROPPARTS("ALTERTABLE_DROPPARTS", new int[]{877, 909}, new Privilege[]{Privilege.DROP}, null),
    ALTERTABLE_ADDPARTS("ALTERTABLE_ADDPARTS", new int[]{866, 907}, null, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_TOUCH("ALTERTABLE_TOUCH", 900, null, null),
    ALTERTABLE_ARCHIVE("ALTERTABLE_ARCHIVE", 867, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_UNARCHIVE("ALTERTABLE_UNARCHIVE", 901, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PROPERTIES("ALTERTABLE_PROPERTIES", new int[]{888, 878}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_OWNER("ALTERTABLE_OWNER", 886, null, null),
    ALTERTABLE_SETPARTSPEC("ALTERTABLE_SETPARTSPEC", 896, null, null),
    ALTERTABLE_EXECUTE("ALTERTABLE_EXECUTE", 882, null, null),
    ALTERTABLE_CREATEBRANCH("ALTERTABLE_CREATEBRANCH", 873, null, null),
    ALTERTABLE_CREATETAG("ALTERTABLE_CREATETAG", 874, null, null),
    ALTERTABLE_DROPBRANCH("ALTERTABLE_DROPBRANCH", 879, null, null),
    ALTERTABLE_RENAMEBRANCH("ALTERTABLE_RENAMEBRANCH", 892, null, null),
    ALTERTABLE_REPLACESNAPSHOTREF("ALTERTABLE_REPLACESNAPSHOTREF", 894, null, null),
    ALTERTABLE_DROPTAG("ALTERTABLE_DROPTAG", 880, null, null),
    ALTERTABLE_CONVERT("ALTERTABLE_CONVERT", 872, null, null),
    ALTERTABLE_SERIALIZER("ALTERTABLE_SERIALIZER", 895, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERIALIZER("ALTERPARTITION_SERIALIZER", 858, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_SERDEPROPERTIES("ALTERTABLE_SERDEPROPERTIES", new int[]{897, 902}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERDEPROPERTIES("ALTERPARTITION_SERDEPROPERTIES", new int[]{859, 860}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_CLUSTER_SORT("ALTERTABLE_CLUSTER_SORT", 870, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ANALYZE_TABLE("ANALYZE_TABLE", 929, null, null),
    CACHE_METADATA("CACHE_METADATA", 939, new Privilege[]{Privilege.SELECT}, null),
    ALTERTABLE_BUCKETNUM("ALTERTABLE_BUCKETNUM", 868, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_BUCKETNUM("ALTERPARTITION_BUCKETNUM", 854, new Privilege[]{Privilege.ALTER_METADATA}, null),
    SHOWCATALOGS("SHOWCATALOGS", 1207, new Privilege[]{Privilege.SHOW_CATALOG}, null, true, false),
    SHOWDATABASES("SHOWDATABASES", 1210, new Privilege[]{Privilege.SHOW_DATABASE}, null, true, false),
    SHOWDATACONNECTORS("SHOWDATACONNECTORS", 1211, new Privilege[]{Privilege.SHOW_DATABASE}, null, true, false),
    SHOWTABLES("SHOWTABLES", 1217, null, null, true, false),
    SHOWCOLUMNS("SHOWCOLUMNS", 1208, null, null, true, false),
    SHOW_TABLESTATUS("SHOW_TABLESTATUS", 1228, null, null, true, false),
    SHOW_TBLPROPERTIES("SHOW_TBLPROPERTIES", 1229, null, null, true, false),
    SHOW_CREATEDATABASE("SHOW_CREATEDATABASE", 1220, new Privilege[]{Privilege.SELECT}, null),
    SHOW_CREATETABLE("SHOW_CREATETABLE", 1221, new Privilege[]{Privilege.SELECT}, null),
    SHOWFUNCTIONS("SHOWFUNCTIONS", 1213, null, null, true, false),
    SHOWPARTITIONS("SHOWPARTITIONS", 1216, null, null),
    SHOWLOCKS("SHOWLOCKS", new int[]{1214, 1212}, null, null, true, false),
    SHOWCONF("SHOWCONF", 1209, null, null),
    SHOWVIEWS("SHOWVIEWS", 1218, null, null, true, false),
    SHOWMATERIALIZEDVIEWS("SHOWMATERIALIZEDVIEWS", 1215, null, null, true, false),
    CREATEFUNCTION("CREATEFUNCTION", 958, null, null),
    DROPFUNCTION("DROPFUNCTION", 1007, null, null),
    RELOADFUNCTION("RELOADFUNCTION", 1166, null, null),
    CREATEMACRO("CREATEMACRO", 959, null, null),
    DROPMACRO("DROPMACRO", 1008, null, null),
    CREATEVIEW("CREATEVIEW", new int[]{962, 908}, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    CREATE_MATERIALIZED_VIEW("CREATE_MATERIALIZED_VIEW", 964, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    DROPVIEW("DROPVIEW", 1011, null, new Privilege[]{Privilege.DROP}),
    DROP_MATERIALIZED_VIEW("DROP_MATERIALIZED_VIEW", 1013, null, new Privilege[]{Privilege.DROP}),
    ALTER_MATERIALIZED_VIEW_REWRITE("ALTER_MATERIALIZED_VIEW_REWRITE", 916, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTER_MATERIALIZED_VIEW_REBUILD("ALTER_MATERIALIZED_VIEW_REBUILD", 915, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE, Privilege.DROP}),
    ALTERVIEW_PROPERTIES("ALTERVIEW_PROPERTIES", new int[]{911, 910}, null, null),
    LOCKTABLE("LOCKTABLE", 1092, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKTABLE("UNLOCKTABLE", 1308, new Privilege[]{Privilege.LOCK}, null),
    CREATEROLE("CREATEROLE", 960, null, null),
    DROPROLE("DROPROLE", 1009, null, null),
    GRANT_PRIVILEGE("GRANT_PRIVILEGE", 1042, null, null),
    REVOKE_PRIVILEGE("REVOKE_PRIVILEGE", 1185, null, null),
    SHOW_GRANT("SHOW_GRANT", 1223, null, null, true, false),
    GRANT_ROLE("GRANT_ROLE", 1044, null, null),
    REVOKE_ROLE("REVOKE_ROLE", 1186, null, null),
    SHOW_ROLES("SHOW_ROLES", new int[]{1224, 1222, 1206}, null, null, true, false),
    SHOW_ROLE_PRINCIPALS("SHOW_ROLE_PRINCIPALS", 1226, null, null, true, false),
    SHOW_ROLE_GRANT("SHOW_ROLE_GRANT", 1225, null, null, true, false),
    ALTERTABLE_FILEFORMAT("ALTERTABLE_FILEFORMAT", 883, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_FILEFORMAT("ALTERPARTITION_FILEFORMAT", 855, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_LOCATION("ALTERTABLE_LOCATION", 884, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERPARTITION_LOCATION("ALTERPARTITION_LOCATION", 856, new Privilege[]{Privilege.ALTER_DATA}, null),
    CREATETABLE("CREATETABLE", 961, null, new Privilege[]{Privilege.CREATE}),
    TRUNCATETABLE("TRUNCATETABLE", 1297, null, new Privilege[]{Privilege.DROP}),
    CREATETABLE_AS_SELECT("CREATETABLE_AS_SELECT", null, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    QUERY("QUERY", 1161, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA, Privilege.CREATE}, true, false),
    ALTERCATALOG_LOCATION("ALTERCATALOG_LOCATION", 845, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERCATALOG_PROPERTIES("ALTERCATALOG_PROPERTIES", 846, null, null),
    ALTERDATABASE("ALTERDATABASE", 850, null, null),
    ALTERDATABASE_OWNER("ALTERDATABASE_OWNER", 849, null, null),
    ALTERDATABASE_LOCATION("ALTERDATABASE_LOCATION", new int[]{847, 848}, new Privilege[]{Privilege.ALTER_DATA}, null),
    DESCCATALOG("DESCCATALOG", 993, null, null),
    DESCDATABASE("DESCDATABASE", 994, null, null),
    ALTERDATACONNECTOR("ALTERDATACONNECTOR", 852, null, null),
    ALTERDATACONNECTOR_OWNER("ALTERDATABASE_OWNER", 851, null, null),
    ALTERDATACONNECTOR_URL("ALTERDATACONNECTOR_", 853, null, null),
    DESCDATACONNECTOR("DESCDATACONNECTOR", 995, null, null),
    ALTERTABLE_MERGEFILES("ALTER_TABLE_MERGE", 885, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERPARTITION_MERGEFILES("ALTER_PARTITION_MERGE", 857, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_SKEWED("ALTERTABLE_SKEWED", 898, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTBLPART_SKEWED_LOCATION("ALTERTBLPART_SKEWED_LOCATION", 899, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PARTCOLTYPE("ALTERTABLE_PARTCOLTYPE", 887, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_EXCHANGEPARTITION("ALTERTABLE_EXCHANGEPARTITION", 881, new Privilege[]{Privilege.SELECT, Privilege.DELETE}, new Privilege[]{Privilege.INSERT}),
    ALTERTABLE_DROPCONSTRAINT("ALTERTABLE_DROPCONSTRAINT", 876, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_ADDCONSTRAINT("ALTERTABLE_ADDCONSTRAINT", 865, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATECOLUMNS("ALTERTABLE_UPDATECOLUMNS", 904, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_RENAME("ALTERVIEW_RENAME", 912, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_AS("ALTERVIEW_AS", 906, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_COMPACT("ALTERTABLE_COMPACT", 871, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    SHOW_COMPACTIONS("SHOW COMPACTIONS", 1219, null, null, true, false),
    SHOW_TRANSACTIONS("SHOW TRANSACTIONS", 1230, null, null, true, false),
    START_TRANSACTION("START TRANSACTION", 1236, null, null, false, false),
    COMMIT("COMMIT", 949, null, null, true, true),
    ROLLBACK("ROLLBACK", 1191, null, null, true, true),
    SET_AUTOCOMMIT("SET AUTOCOMMIT", 1204, null, null, true, false),
    ABORT_TRANSACTIONS("ABORT TRANSACTIONS", 837, null, null, false, false),
    ABORT_COMPACTION("ABORT COMPACTIONS", 836, null, null, false, false),
    KILL_QUERY("KILL QUERY", 1078, null, null),
    CREATE_RESOURCEPLAN("CREATE RESOURCEPLAN", 966, null, null, false, false),
    SHOW_RESOURCEPLAN("SHOW RESOURCEPLAN", 1227, null, null, false, false),
    ALTER_RESOURCEPLAN("ALTER RESOURCEPLAN", new int[]{926, 922, 924, 925, 921, 920, 923}, null, null, false, false),
    DROP_RESOURCEPLAN("DROP RESOURCEPLAN", 1015, null, null, false, false),
    CREATE_TRIGGER("CREATE TRIGGER", 968, null, null, false, false),
    ALTER_TRIGGER("ALTER TRIGGER", 928, null, null, false, false),
    DROP_TRIGGER("DROP TRIGGER", 1017, null, null, false, false),
    CREATE_POOL("CREATE POOL", 965, null, null, false, false),
    ALTER_POOL("ALTER POOL", new int[]{917, 918, 919}, null, null, false, false),
    DROP_POOL("DROP POOL", 1014, null, null, false, false),
    CREATE_MAPPING("CREATE MAPPING", 963, null, null, false, false),
    ALTER_MAPPING("ALTER MAPPING", 913, null, null, false, false),
    DROP_MAPPING("DROP MAPPING", 1012, null, null, false, false),
    CREATE_SCHEDULED_QUERY("CREATE SCHEDULED QUERY", 967, null, null),
    ALTER_SCHEDULED_QUERY("ALTER SCHEDULED QUERY", 927, null, null),
    DROP_SCHEDULED_QUERY("DROP SCHEDULED QUERY", 1016, null, null),
    PREPARE("PREPARE QUERY", 1140, null, null),
    EXECUTE("EXECUTE QUERY", 1022, null, null);

    private final String operationName;
    private final int[] tokens;
    private final Privilege[] inputRequiredPrivileges;
    private final Privilege[] outputRequiredPrivileges;
    private final boolean allowedInTransaction;
    private final boolean requiresOpenTransaction;
    private static final Map<Integer, HiveOperation> TOKEN_TO_OPERATION;

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, tokens, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, allowedInTransaction, requiresOpenTransaction);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this.operationName = operationName;
        this.tokens = tokens;
        this.inputRequiredPrivileges = inputRequiredPrivileges;
        this.outputRequiredPrivileges = outputRequiredPrivileges;
        this.requiresOpenTransaction = requiresOpenTransaction;
        this.allowedInTransaction = allowedInTransaction || requiresOpenTransaction;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Privilege[] getInputRequiredPrivileges() {
        return this.inputRequiredPrivileges;
    }

    public Privilege[] getOutputRequiredPrivileges() {
        return this.outputRequiredPrivileges;
    }

    public boolean isAllowedInTransaction() {
        return this.allowedInTransaction;
    }

    public boolean isRequiresOpenTransaction() {
        return this.requiresOpenTransaction;
    }

    public static HiveOperation operationForToken(int token) {
        return TOKEN_TO_OPERATION.get(token);
    }

    static {
        TOKEN_TO_OPERATION = new HashMap<Integer, HiveOperation>();
        for (HiveOperation hiveOperation : HiveOperation.values()) {
            if (hiveOperation.tokens == null) continue;
            for (int token : hiveOperation.tokens) {
                TOKEN_TO_OPERATION.put(token, hiveOperation);
            }
        }
    }
}

