/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.json.BinaryEncoding;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveJsonWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HiveJsonWriter.class);
    private final EnumSet<Feature> features = EnumSet.noneOf(Feature.class);
    private final List<String> rootStructFieldNames;
    private final JsonNodeFactory nodeFactory;
    private final ObjectMapper mapper;
    private BinaryEncoding binaryEncoding;

    public HiveJsonWriter() {
        this(BinaryEncoding.BASE64, Collections.emptyList());
    }

    public HiveJsonWriter(BinaryEncoding encoding, List<String> rootStructFieldNames) {
        this.binaryEncoding = encoding;
        this.rootStructFieldNames = rootStructFieldNames;
        this.nodeFactory = JsonNodeFactory.instance;
        this.mapper = new ObjectMapper();
    }

    public String write(Object o, ObjectInspector objInspector) throws SerDeException {
        JsonNode rootNode = this.walkObjectGraph(objInspector, o, this.rootStructFieldNames);
        LOG.debug("Create JSON tree from Object tree: {}", (Object)rootNode);
        try {
            ObjectWriter ow = this.isEnabled(Feature.PRETTY_PRINT) ? this.mapper.writerWithDefaultPrettyPrinter() : this.mapper.writer();
            return ow.writeValueAsString((Object)rootNode);
        }
        catch (JsonProcessingException e) {
            throw new SerDeException(e);
        }
    }

    private JsonNode walkObjectGraph(ObjectInspector oi, Object o, List<String> fieldNames) throws SerDeException {
        if (o != null) {
            switch (oi.getCategory()) {
                case LIST: {
                    return this.visitList(oi, o);
                }
                case STRUCT: {
                    return this.visitStruct(oi, o, fieldNames);
                }
                case MAP: {
                    return this.visitMap(oi, o);
                }
                case PRIMITIVE: {
                    return this.primitiveToNode(oi, o);
                }
                case UNION: {
                    return this.visitUnion(oi, o);
                }
            }
            throw new SerDeException("Parsing of: " + String.valueOf((Object)oi.getCategory()) + " is not supported");
        }
        return this.nodeFactory.nullNode();
    }

    private ObjectNode visitMap(ObjectInspector oi, Object o) throws SerDeException {
        MapObjectInspector moi = (MapObjectInspector)oi;
        ObjectInspector mapKeyInspector = moi.getMapKeyObjectInspector();
        ObjectInspector mapValueInspector = moi.getMapValueObjectInspector();
        Map<?, ?> map = moi.getMap(o);
        ObjectNode objectNode = this.nodeFactory.objectNode();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            ValueNode keyNode = this.primitiveToNode(mapKeyInspector, entry.getKey());
            JsonNode valueNode = this.walkObjectGraph(mapValueInspector, entry.getValue(), Collections.emptyList());
            objectNode.set(keyNode.asText(), valueNode);
        }
        return objectNode;
    }

    private ContainerNode<?> visitList(ObjectInspector oi, Object o) throws SerDeException {
        ListObjectInspector loi = (ListObjectInspector)oi;
        List<?> list = loi.getList(o);
        ArrayNode arrayNode = this.nodeFactory.arrayNode(list.size());
        for (Object item : list) {
            JsonNode valueNode = this.walkObjectGraph(loi.getListElementObjectInspector(), item, Collections.emptyList());
            arrayNode.add(valueNode);
        }
        return arrayNode;
    }

    private ObjectNode visitStruct(ObjectInspector oi, Object o, List<String> fieldNames) throws SerDeException {
        StructObjectInspector structInspector = (StructObjectInspector)oi;
        ObjectNode structNode = this.nodeFactory.objectNode();
        for (StructField structField : structInspector.getAllStructFieldRefs()) {
            Object fieldValue = structInspector.getStructFieldData(o, structField);
            ObjectInspector coi = structField.getFieldObjectInspector();
            JsonNode fieldNode = this.walkObjectGraph(coi, fieldValue, Collections.emptyList());
            String fieldName = fieldNames.isEmpty() ? structField.getFieldName() : fieldNames.get(structField.getFieldID());
            structNode.set(fieldName, fieldNode);
        }
        return structNode;
    }

    private ObjectNode visitUnion(ObjectInspector oi, Object o) throws SerDeException {
        UnionObjectInspector unionInspector = (UnionObjectInspector)oi;
        ObjectNode unionNode = this.nodeFactory.objectNode();
        byte tag = unionInspector.getTag(o);
        String tagText = Byte.toString(tag);
        JsonNode valueNode = this.walkObjectGraph(unionInspector.getObjectInspectors().get(tag), unionInspector.getField(o), Collections.emptyList());
        unionNode.set(tagText, valueNode);
        return unionNode;
    }

    private ValueNode primitiveToNode(ObjectInspector oi, Object o) throws SerDeException {
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
        switch (poi.getPrimitiveCategory()) {
            case BINARY: {
                return this.getByteValue(((BinaryObjectInspector)poi).getPrimitiveJavaObject(o));
            }
            case BOOLEAN: {
                return this.nodeFactory.booleanNode(((BooleanObjectInspector)poi).get(o));
            }
            case BYTE: {
                return this.nodeFactory.numberNode(((ByteObjectInspector)poi).get(o));
            }
            case DATE: {
                return this.nodeFactory.textNode(((DateObjectInspector)poi).getPrimitiveJavaObject(o).toString());
            }
            case DECIMAL: {
                return this.nodeFactory.numberNode(((HiveDecimalObjectInspector)poi).getPrimitiveJavaObject(o).bigDecimalValue());
            }
            case DOUBLE: {
                return this.nodeFactory.numberNode(((DoubleObjectInspector)poi).get(o));
            }
            case FLOAT: {
                return this.nodeFactory.numberNode(((FloatObjectInspector)poi).get(o));
            }
            case INT: {
                return this.nodeFactory.numberNode(((IntObjectInspector)poi).get(o));
            }
            case LONG: {
                return this.nodeFactory.numberNode(((LongObjectInspector)poi).get(o));
            }
            case SHORT: {
                return this.nodeFactory.numberNode(((ShortObjectInspector)poi).get(o));
            }
            case STRING: {
                return this.nodeFactory.textNode(((StringObjectInspector)poi).getPrimitiveJavaObject(o));
            }
            case CHAR: {
                return this.nodeFactory.textNode(((HiveCharObjectInspector)poi).getPrimitiveJavaObject(o).toString());
            }
            case VARCHAR: {
                return this.nodeFactory.textNode(((HiveVarcharObjectInspector)poi).getPrimitiveJavaObject(o).toString());
            }
            case TIMESTAMP: {
                return this.nodeFactory.textNode(((TimestampObjectInspector)poi).getPrimitiveJavaObject(o).toString());
            }
        }
        throw new SerDeException("Unsupported type: " + String.valueOf((Object)poi.getPrimitiveCategory()));
    }

    private ValueNode getByteValue(byte[] buf) throws SerDeException {
        switch (this.binaryEncoding) {
            case RAWSTRING: {
                Text txt = new Text();
                txt.set(buf, 0, buf.length);
                return this.nodeFactory.textNode(txt.toString());
            }
            case BASE64: {
                return this.nodeFactory.binaryNode(buf);
            }
        }
        throw new SerDeException("Error generating JSON binary type from record.");
    }

    public void enable(Feature feature) {
        this.features.add(feature);
    }

    public void disable(Feature feature) {
        this.features.remove((Object)feature);
    }

    public Set<Feature> getFeatures() {
        return Collections.unmodifiableSet(this.features);
    }

    public boolean isEnabled(Feature feature) {
        return this.features.contains((Object)feature);
    }

    public BinaryEncoding getBinaryEncodingType() {
        return this.binaryEncoding;
    }

    public void setBinaryEncoding(BinaryEncoding encoding) {
        this.binaryEncoding = encoding;
    }

    public String toString() {
        return "HiveJsonWriter [features=" + String.valueOf(this.features) + ", rootStructFieldNames=" + String.valueOf(this.rootStructFieldNames) + ", binaryEncoding=" + String.valueOf((Object)this.binaryEncoding) + "]";
    }

    public static enum Feature {
        PRETTY_PRINT;

    }
}

