/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools.json;

import org.apache.orc.TypeDescription;
import org.apache.orc.tools.json.HiveType;

class NumericType
extends HiveType {
    int intDigits;
    int scale;

    NumericType(HiveType.Kind kind, int intDigits, int scale) {
        super(kind);
        this.intDigits = intDigits;
        this.scale = scale;
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            NumericType otherNumber = (NumericType)other;
            return this.intDigits == otherNumber.intDigits || this.scale == otherNumber.scale;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 41 + this.intDigits * 17 + this.scale;
    }

    public String toString() {
        switch (this.kind) {
            case BYTE: {
                return "tinyint";
            }
            case SHORT: {
                return "smallint";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "bigint";
            }
            case DECIMAL: {
                return "decimal(" + (this.intDigits + this.scale) + "," + this.scale + ")";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
        }
        throw new IllegalArgumentException("Unknown kind " + String.valueOf((Object)this.kind));
    }

    @Override
    public boolean subsumes(HiveType other) {
        return other.getClass() == NumericType.class || other.kind == HiveType.Kind.NULL;
    }

    @Override
    public void merge(HiveType other) {
        if (other.getClass() == NumericType.class) {
            NumericType otherNumber = (NumericType)other;
            this.intDigits = Math.max(this.intDigits, otherNumber.intDigits);
            this.scale = Math.max(this.scale, otherNumber.scale);
            if (this.kind.rank < other.kind.rank) {
                this.kind = other.kind;
            }
        }
    }

    @Override
    public TypeDescription getSchema() {
        switch (this.kind) {
            case BYTE: {
                return TypeDescription.createByte();
            }
            case SHORT: {
                return TypeDescription.createShort();
            }
            case INT: {
                return TypeDescription.createInt();
            }
            case LONG: {
                return TypeDescription.createLong();
            }
            case DECIMAL: {
                return TypeDescription.createDecimal().withScale(this.scale).withPrecision(this.intDigits + this.scale);
            }
            case FLOAT: {
                return TypeDescription.createFloat();
            }
            case DOUBLE: {
                return TypeDescription.createDouble();
            }
        }
        throw new IllegalArgumentException("Unknown kind " + String.valueOf((Object)this.kind));
    }
}

