/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.kll;

import org.apache.datasketches.hive.kll.ObjectInspectorValidator;
import org.apache.datasketches.hive.kll.SketchEvaluator;
import org.apache.datasketches.hive.kll.SketchState;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="DataToSketch", value="_FUNC_(value, k) - Returns a KllFloatsSketch in a serialized form as a binary blob. Values must be of type float. Parameter k controls the accuracy and the size of the sketch. If k is ommitted, the default is used.")
public class DataToSketchUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] inspectors = info.getParameterObjectInspectors();
        if (inspectors.length != 1 && inspectors.length != 2) {
            throw new UDFArgumentException("One or two arguments expected");
        }
        ObjectInspectorValidator.validateGivenPrimitiveCategory(inspectors[0], 0, PrimitiveObjectInspector.PrimitiveCategory.FLOAT);
        if (inspectors.length == 2) {
            ObjectInspectorValidator.validateGivenPrimitiveCategory(inspectors[1], 1, PrimitiveObjectInspector.PrimitiveCategory.INT);
        }
        return new DataToSketchEvaluator();
    }

    static class DataToSketchEvaluator
    extends SketchEvaluator {
        DataToSketchEvaluator() {
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer buf, Object[] data) throws HiveException {
            if (data[0] == null) {
                return;
            }
            SketchState state = (SketchState)buf;
            if (!state.isInitialized()) {
                if (this.kInspector_ != null) {
                    state.init(PrimitiveObjectInspectorUtils.getInt((Object)data[1], (PrimitiveObjectInspector)this.kInspector_));
                } else {
                    state.init();
                }
            }
            float value = ((Float)this.inputInspector_.getPrimitiveJavaObject(data[0])).floatValue();
            state.update(value);
        }
    }
}

