/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.JaccardSimilarity;
import org.apache.datasketches.theta.Sketch;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

public class EstimateSketchSimilarityUDF
extends UDF {
    public double evaluate(BytesWritable firstSketchBytes, BytesWritable secondSketchBytes) {
        Sketch firstSketch = null;
        if (firstSketchBytes != null && firstSketchBytes.getLength() > 0) {
            firstSketch = Sketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(firstSketchBytes), (long)9001L);
        }
        Sketch secondSketch = null;
        if (secondSketchBytes != null && secondSketchBytes.getLength() > 0) {
            secondSketch = Sketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(secondSketchBytes), (long)9001L);
        }
        double[] jaccard = JaccardSimilarity.jaccard(firstSketch, secondSketch);
        return jaccard[1];
    }
}

