/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hugegraph.computer.core.input.InputSplit;
import org.apache.hugegraph.computer.core.input.InputSplitFetcher;
import org.apache.hugegraph.computer.core.rpc.InputSplitRpcService;

public class MasterInputHandler
implements InputSplitRpcService {
    private final InputSplitFetcher fetcher;
    private final Queue<InputSplit> vertexSplits;
    private final Queue<InputSplit> edgeSplits;

    public MasterInputHandler(InputSplitFetcher fetcher) {
        this.fetcher = fetcher;
        this.vertexSplits = new LinkedBlockingQueue<InputSplit>();
        this.edgeSplits = new LinkedBlockingQueue<InputSplit>();
    }

    public int createVertexInputSplits() {
        List<InputSplit> splits = this.fetcher.fetchVertexInputSplits();
        for (InputSplit split : splits) {
            this.vertexSplits.offer(split);
        }
        return this.vertexSplits.size();
    }

    public int createEdgeInputSplits() {
        List<InputSplit> splits = this.fetcher.fetchEdgeInputSplits();
        for (InputSplit split : splits) {
            this.edgeSplits.offer(split);
        }
        return this.edgeSplits.size();
    }

    @Override
    public InputSplit nextVertexInputSplit() {
        InputSplit split = this.vertexSplits.poll();
        return split != null ? split : InputSplit.END_SPLIT;
    }

    @Override
    public InputSplit nextEdgeInputSplit() {
        InputSplit split = this.edgeSplits.poll();
        return split != null ? split : InputSplit.END_SPLIT;
    }
}

