/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.AbstractLifeCycle;
import com.alipay.remoting.ConnectionMonitorStrategy;
import com.alipay.remoting.ConnectionPool;
import com.alipay.remoting.DefaultConnectionManager;
import com.alipay.remoting.LifeCycleException;
import com.alipay.remoting.NamedThreadFactory;
import com.alipay.remoting.config.ConfigManager;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.RunStateRecordedFutureTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class DefaultConnectionMonitor
extends AbstractLifeCycle {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    private final DefaultConnectionManager connectionManager;
    private final ConnectionMonitorStrategy strategy;
    private ScheduledThreadPoolExecutor executor;

    public DefaultConnectionMonitor(ConnectionMonitorStrategy strategy, DefaultConnectionManager connectionManager) {
        if (strategy == null) {
            throw new IllegalArgumentException("null strategy");
        }
        if (connectionManager == null) {
            throw new IllegalArgumentException("null connectionManager");
        }
        this.strategy = strategy;
        this.connectionManager = connectionManager;
    }

    @Override
    public void startup() throws LifeCycleException {
        super.startup();
        long initialDelay = ConfigManager.conn_monitor_initial_delay();
        long period = ConfigManager.conn_monitor_period();
        this.executor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("ConnectionMonitorThread", true), new ThreadPoolExecutor.AbortPolicy());
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ConcurrentHashMap<String, RunStateRecordedFutureTask<ConnectionPool>> connPools = DefaultConnectionMonitor.this.connectionManager.getConnPools();
                    DefaultConnectionMonitor.this.strategy.monitor(connPools);
                }
                catch (Exception e) {
                    logger.warn("MonitorTask error", (Throwable)e);
                }
            }
        }, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() throws LifeCycleException {
        super.shutdown();
        this.executor.purge();
        this.executor.shutdown();
    }

    @Deprecated
    public void start() {
        this.startup();
    }

    @Deprecated
    public void destroy() {
        this.shutdown();
    }
}

