/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store;

import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.BackendTable;
import org.apache.hugegraph.backend.store.MetaDispatcher;
import org.apache.hugegraph.backend.store.MetaHandler;
import org.apache.hugegraph.backend.store.SystemSchemaStore;
import org.apache.hugegraph.exception.ConnectionException;
import org.apache.hugegraph.type.HugeType;

public abstract class AbstractBackendStore<Session extends BackendSession>
implements BackendStore {
    private final SystemSchemaStore systemSchemaStore = new SystemSchemaStore();
    private final MetaDispatcher<Session> dispatcher = new MetaDispatcher();

    protected MetaDispatcher<Session> metaDispatcher() {
        return this.dispatcher;
    }

    public void registerMetaHandler(String name, MetaHandler<Session> handler) {
        this.dispatcher.registerMetaHandler(name, handler);
    }

    @Override
    public String storedVersion() {
        throw new UnsupportedOperationException("AbstractBackendStore.storedVersion()");
    }

    @Override
    public SystemSchemaStore systemSchemaStore() {
        return this.systemSchemaStore;
    }

    @Override
    public <R> R metadata(HugeType type, String meta, Object[] args) {
        MetaDispatcher<Session> dispatcher;
        Session session = this.session(type);
        if (type == null) {
            dispatcher = this.metaDispatcher();
        } else {
            BackendTable<Session, ?> table = this.table(type);
            dispatcher = table.metaDispatcher();
        }
        return dispatcher.dispatchMetaHandler(session, meta, args);
    }

    protected void checkOpened() throws ConnectionException {
        if (!this.opened()) {
            throw new ConnectionException("The '%s' store of %s has not been opened", this.database(), this.provider().type());
        }
    }

    public String toString() {
        return String.format("%s/%s", this.database(), this.store());
    }

    protected abstract BackendTable<Session, ?> table(HugeType var1);

    protected abstract Session session(HugeType var1);
}

