/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.optimize;

import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.backend.query.BatchConditionQuery;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.iterator.BatchMapperIterator;
import org.apache.hugegraph.traversal.optimize.HugeVertexStep;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public class HugeVertexStepByBatch<E extends Element>
extends HugeVertexStep<E> {
    private static final long serialVersionUID = -3609787815053052222L;
    private BatchMapperIterator<Traverser.Admin<Vertex>, E> batchIterator = null;
    private Traverser.Admin<Vertex> head = null;
    private Iterator<E> iterator = null;

    public HugeVertexStepByBatch(VertexStep<E> originalVertexStep) {
        super(originalVertexStep);
    }

    protected Traverser.Admin<E> processNextStart() {
        if (this.batchIterator == null) {
            int batchSize = 100;
            this.batchIterator = new BatchMapperIterator(batchSize, (Iterator)this.starts, this::flatMap);
        }
        if (this.batchIterator.hasNext()) {
            assert (this.head != null);
            Element item = (Element)this.batchIterator.next();
            return this.head.split((Object)item, (Step)this);
        }
        throw FastNoSuchElementException.instance();
    }

    public void reset() {
        super.reset();
        this.closeIterator();
        this.batchIterator = null;
        this.head = null;
    }

    @Override
    public Iterator<?> lastTimeResults() {
        return this.iterator;
    }

    protected void closeIterator() {
        CloseableIterator.closeIterator(this.batchIterator);
    }

    private Iterator<E> flatMap(List<Traverser.Admin<Vertex>> traversers) {
        if (this.head == null && traversers.size() > 0) {
            this.head = traversers.get(0);
        }
        boolean queryVertex = this.returnsVertex();
        boolean queryEdge = this.returnsEdge();
        assert (queryVertex || queryEdge);
        if (queryVertex) {
            this.iterator = this.vertices(traversers);
        } else {
            assert (queryEdge);
            this.iterator = this.edges(traversers);
        }
        return this.iterator;
    }

    private Iterator<Vertex> vertices(List<Traverser.Admin<Vertex>> traversers) {
        assert (traversers.size() > 0);
        Iterator<Edge> edges = this.edges(traversers);
        return this.queryAdjacentVertices(edges);
    }

    private Iterator<Edge> edges(List<Traverser.Admin<Vertex>> traversers) {
        assert (traversers.size() > 0);
        BatchConditionQuery batchQuery = new BatchConditionQuery(HugeType.EDGE, traversers.size());
        for (Traverser.Admin<Vertex> traverser : traversers) {
            ConditionQuery query = this.constructEdgesQuery(traverser);
            batchQuery.mergeToIN(query, HugeKeys.OWNER_VERTEX);
        }
        this.injectQueryInfo(batchQuery);
        return this.queryEdges(batchQuery);
    }
}

