/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.keyword;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.ansj.app.keyword.Keyword;
import org.ansj.domain.Term;
import org.ansj.splitWord.Analysis;
import org.ansj.splitWord.analysis.NlpAnalysis;
import org.nlpcn.commons.lang.util.StringUtil;

public class KeyWordComputer<T extends Analysis> {
    private static final Map<String, Double> POS_SCORE = new HashMap<String, Double>();
    private T analysisType;
    private int nKeyword = 5;

    public KeyWordComputer() {
    }

    public void setAnalysisType(T analysisType) {
        this.analysisType = analysisType;
    }

    public KeyWordComputer(int nKeyword) {
        this.nKeyword = nKeyword;
        this.analysisType = new NlpAnalysis();
    }

    public KeyWordComputer(int nKeyword, T analysisType) {
        this.nKeyword = nKeyword;
        this.analysisType = analysisType;
    }

    private List<Keyword> computeArticleTfidf(String content, int titleLength) {
        HashMap<String, Keyword> tm = new HashMap<String, Keyword>();
        List<Term> parse = ((Analysis)this.analysisType).parseStr(content).getTerms();
        for (Term term : parse) {
            double weight = this.getWeight(term, content.length(), titleLength);
            if (weight == 0.0) continue;
            Keyword keyword = (Keyword)tm.get(term.getName());
            if (keyword == null) {
                keyword = new Keyword(term.getName(), term.termNatures().allFreq, weight);
                tm.put(term.getName(), keyword);
                continue;
            }
            keyword.updateWeight(1);
        }
        TreeSet treeSet = new TreeSet(tm.values());
        ArrayList<Keyword> arrayList = new ArrayList<Keyword>(treeSet);
        if (treeSet.size() <= this.nKeyword) {
            return arrayList;
        }
        return arrayList.subList(0, this.nKeyword);
    }

    public List<Keyword> computeArticleTfidf(String title, String content) {
        if (StringUtil.isBlank((CharSequence)title)) {
            title = "";
        }
        if (StringUtil.isBlank((CharSequence)content)) {
            content = "";
        }
        return this.computeArticleTfidf(title + "\t" + content, title.length());
    }

    public List<Keyword> computeArticleTfidf(String content) {
        return this.computeArticleTfidf(content, 0);
    }

    private double getWeight(Term term, int length, int titleLength) {
        if (term.getName().trim().length() < 2) {
            return 0.0;
        }
        String pos = term.natrue().natureStr;
        Double posScore = POS_SCORE.get(pos);
        if (posScore == null) {
            posScore = 1.0;
        } else if (posScore == 0.0) {
            return 0.0;
        }
        if (titleLength > term.getOffe()) {
            return 5.0 * posScore;
        }
        return (double)(length - term.getOffe()) * posScore / (double)length;
    }

    static {
        POS_SCORE.put("null", 0.0);
        POS_SCORE.put("w", 0.0);
        POS_SCORE.put("en", 0.0);
        POS_SCORE.put("m", 0.0);
        POS_SCORE.put("num", 0.0);
        POS_SCORE.put("nr", 3.0);
        POS_SCORE.put("nrf", 3.0);
        POS_SCORE.put("nw", 3.0);
        POS_SCORE.put("nt", 3.0);
        POS_SCORE.put("l", 0.2);
        POS_SCORE.put("a", 0.2);
        POS_SCORE.put("nz", 3.0);
        POS_SCORE.put("v", 0.2);
        POS_SCORE.put("kw", 6.0);
    }
}

