/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;

public final class DropFunctionStatement
extends AlterSchemaStatement {
    private final String functionName;
    private final Collection<CQL3Type.Raw> arguments;
    private final boolean argumentsSpeficied;
    private final boolean ifExists;

    public DropFunctionStatement(String keyspaceName, String functionName, Collection<CQL3Type.Raw> arguments, boolean argumentsSpeficied, boolean ifExists) {
        super(keyspaceName);
        this.functionName = functionName;
        this.arguments = arguments;
        this.argumentsSpeficied = argumentsSpeficied;
        this.ifExists = ifExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        Function function;
        String name = this.argumentsSpeficied ? String.format("%s.%s(%s)", this.keyspaceName, this.functionName, String.join((CharSequence)", ", Iterables.transform(this.arguments, Object::toString))) : String.format("%s.%s", this.keyspaceName, this.functionName);
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        if (null == keyspace) {
            if (this.ifExists) {
                return schema;
            }
            throw DropFunctionStatement.ire("Function '%s' doesn't exist", name);
        }
        Collection<Function> functions = keyspace.functions.get(new FunctionName(this.keyspaceName, this.functionName));
        if (functions.size() > 1 && !this.argumentsSpeficied) {
            throw DropFunctionStatement.ire("'DROP FUNCTION %s' matches multiple function definitions; specify the argument types by issuing a statement like 'DROP FUNCTION %s (type, type, ...)'. You can use cqlsh 'DESCRIBE FUNCTION %s' command to find all overloads", this.functionName, this.functionName, this.functionName);
        }
        this.arguments.stream().filter(raw -> !raw.isTuple() && raw.isFrozen()).findFirst().ifPresent(t -> {
            throw DropFunctionStatement.ire("Argument '%s' cannot be frozen; remove frozen<> modifier from '%s'", t, t);
        });
        List<AbstractType<?>> argumentTypes = this.prepareArgumentTypes(keyspace.types);
        Predicate<Function> filter = Functions.Filter.UDF;
        if (this.argumentsSpeficied) {
            filter = filter.and(f -> Functions.typesMatch(f.argTypes(), argumentTypes));
        }
        if (null == (function = (Function)functions.stream().filter(filter).findAny().orElse(null))) {
            if (this.ifExists) {
                return schema;
            }
            throw DropFunctionStatement.ire("Function '%s' doesn't exist", name);
        }
        String dependentAggregates = keyspace.functions.aggregatesUsingFunction(function).map(a -> a.name().toString()).collect(Collectors.joining(", "));
        if (!dependentAggregates.isEmpty()) {
            throw DropFunctionStatement.ire("Function '%s' is still referenced by aggregates %s", name, dependentAggregates);
        }
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.functions.without(function)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        Functions dropped = (Functions)((KeyspaceMetadata.KeyspaceDiff)diff.altered.get((int)0)).udfs.dropped;
        assert (dropped.size() == 1);
        return Event.SchemaChange.forFunction(Event.SchemaChange.Change.DROPPED, (UDFunction)dropped.iterator().next());
    }

    @Override
    public void authorize(ClientState client) {
        KeyspaceMetadata keyspace = Schema.instance.getKeyspaceMetadata(this.keyspaceName);
        if (null == keyspace) {
            return;
        }
        Stream<Function> functions = keyspace.functions.get(new FunctionName(this.keyspaceName, this.functionName)).stream();
        if (this.argumentsSpeficied) {
            functions = functions.filter(f -> Functions.typesMatch(f.argTypes(), this.prepareArgumentTypes(keyspace.types)));
        }
        functions.forEach(f -> client.ensurePermission(Permission.DROP, FunctionResource.function(f)));
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.DROP_FUNCTION, this.keyspaceName, this.functionName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.functionName);
    }

    private List<AbstractType<?>> prepareArgumentTypes(Types types) {
        return this.arguments.stream().map(t -> t.prepare(this.keyspaceName, types)).map(CQL3Type::getType).collect(Collectors.toList());
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final FunctionName name;
        private final List<CQL3Type.Raw> arguments;
        private final boolean argumentsSpecified;
        private final boolean ifExists;

        public Raw(FunctionName name, List<CQL3Type.Raw> arguments, boolean argumentsSpecified, boolean ifExists) {
            this.name = name;
            this.arguments = arguments;
            this.argumentsSpecified = argumentsSpecified;
            this.ifExists = ifExists;
        }

        @Override
        public DropFunctionStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.keyspace : state.getKeyspace();
            return new DropFunctionStatement(keyspaceName, this.name.name, this.arguments, this.argumentsSpecified, this.ifExists);
        }
    }
}

