/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.tokenizer;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.dictionary.other.CharTable;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.SentencesUtil;
import java.util.LinkedList;
import java.util.List;

public class TraditionalChineseTokenizer {
    public static Segment SEGMENT = HanLP.newSegment();

    private static List<Term> segSentence(String text) {
        String sText = CharTable.convert(text);
        List<Term> termList = SEGMENT.seg(sText);
        int offset = 0;
        for (Term term : termList) {
            term.offset = offset;
            term.word = text.substring(offset, offset + term.length());
            offset += term.length();
        }
        return termList;
    }

    public static List<Term> segment(String text) {
        LinkedList<Term> termList = new LinkedList<Term>();
        for (String sentence : SentencesUtil.toSentenceList(text)) {
            termList.addAll(TraditionalChineseTokenizer.segSentence(sentence));
        }
        return termList;
    }

    public static List<Term> segment(char[] text) {
        return TraditionalChineseTokenizer.segment(CharTable.convert(text));
    }

    public static List<List<Term>> seg2sentence(String text) {
        LinkedList<List<Term>> resultList = new LinkedList<List<Term>>();
        for (String sentence : SentencesUtil.toSentenceList(text)) {
            resultList.add(TraditionalChineseTokenizer.segment(sentence));
        }
        return resultList;
    }

    public static List<List<Term>> seg2sentence(String text, boolean shortest) {
        return SEGMENT.seg2sentence(text, shortest);
    }
}

