/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.mock;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.mock.MockTracer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class MockSpan
implements Span {
    private static AtomicLong nextId = new AtomicLong(0L);
    private final MockTracer mockTracer;
    private MockContext context;
    private final long parentId;
    private final long startMicros;
    private boolean finished;
    private long finishMicros;
    private final Map<String, Object> tags;
    private final List<LogEntry> logEntries = new ArrayList<LogEntry>();
    private String operationName;
    private final List<RuntimeException> errors = new ArrayList<RuntimeException>();

    public String operationName() {
        return this.operationName;
    }

    public Span setOperationName(String operationName) {
        this.finishedCheck("Setting operationName {%s} on already finished span", operationName);
        this.operationName = operationName;
        return this;
    }

    public long parentId() {
        return this.parentId;
    }

    public long startMicros() {
        return this.startMicros;
    }

    public long finishMicros() {
        assert (this.finishMicros > 0L) : "must call finish() before finishMicros()";
        return this.finishMicros;
    }

    public Map<String, Object> tags() {
        return new HashMap<String, Object>(this.tags);
    }

    public List<LogEntry> logEntries() {
        return new ArrayList<LogEntry>(this.logEntries);
    }

    public List<RuntimeException> generatedErrors() {
        return new ArrayList<RuntimeException>(this.errors);
    }

    public synchronized MockContext context() {
        return this.context;
    }

    public void finish() {
        this.finish(MockSpan.nowMicros());
    }

    public synchronized void finish(long finishMicros) {
        this.finishedCheck("Finishing already finished span", new Object[0]);
        this.finishMicros = finishMicros;
        this.mockTracer.appendFinishedSpan(this);
        this.finished = true;
    }

    public void close() {
        this.finish();
    }

    public Span setTag(String key, String value) {
        return this.setObjectTag(key, value);
    }

    public Span setTag(String key, boolean value) {
        return this.setObjectTag(key, value);
    }

    public Span setTag(String key, Number value) {
        return this.setObjectTag(key, value);
    }

    private synchronized Span setObjectTag(String key, Object value) {
        this.finishedCheck("Adding tag {%s:%s} to already finished span", key, value);
        this.tags.put(key, value);
        return this;
    }

    public final Span log(Map<String, ?> fields) {
        return this.log(MockSpan.nowMicros(), fields);
    }

    public final synchronized Span log(long timestampMicros, Map<String, ?> fields) {
        this.finishedCheck("Adding logs %s at %d to already finished span", fields, timestampMicros);
        this.logEntries.add(new LogEntry(timestampMicros, fields));
        return this;
    }

    public Span log(String event) {
        return this.log(MockSpan.nowMicros(), event);
    }

    public Span log(long timestampMicroseconds, String event) {
        return this.log(timestampMicroseconds, Collections.singletonMap("event", event));
    }

    public Span log(String eventName, Object payload) {
        return this.log(MockSpan.nowMicros(), eventName, payload);
    }

    public Span log(long timestampMicroseconds, String eventName, Object payload) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("event", eventName);
        if (payload != null) {
            fields.put("payload", payload);
        }
        return this.log(timestampMicroseconds, fields);
    }

    public synchronized Span setBaggageItem(String key, String value) {
        this.finishedCheck("Adding baggage {%s:%s} to already finished span", key, value);
        this.context = this.context.withBaggageItem(key, value);
        return this;
    }

    public synchronized String getBaggageItem(String key) {
        return this.context.getBaggageItem(key);
    }

    MockSpan(MockTracer tracer, String operationName, long startMicros, Map<String, Object> initialTags, MockContext parent) {
        this.mockTracer = tracer;
        this.operationName = operationName;
        this.startMicros = startMicros;
        this.tags = initialTags == null ? new HashMap<String, Object>() : new HashMap<String, Object>(initialTags);
        if (parent == null) {
            this.context = new MockContext(MockSpan.nextId(), MockSpan.nextId(), new HashMap<String, String>());
            this.parentId = 0L;
        } else {
            this.context = new MockContext(parent.traceId, MockSpan.nextId(), parent.baggage);
            this.parentId = parent.spanId;
        }
    }

    static long nextId() {
        return nextId.addAndGet(1L);
    }

    static long nowMicros() {
        return System.currentTimeMillis() * 1000L;
    }

    private synchronized void finishedCheck(String format, Object ... args) {
        if (this.finished) {
            IllegalStateException ex = new IllegalStateException(String.format(format, args));
            this.errors.add(ex);
            throw ex;
        }
    }

    public String toString() {
        return "{traceId:" + this.context.traceId() + ", spanId:" + this.context.spanId() + ", parentId:" + this.parentId + ", operationName:\"" + this.operationName + "\"}";
    }

    public static final class LogEntry {
        private final long timestampMicros;
        private final Map<String, ?> fields;

        public LogEntry(long timestampMicros, Map<String, ?> fields) {
            this.timestampMicros = timestampMicros;
            this.fields = fields;
        }

        public long timestampMicros() {
            return this.timestampMicros;
        }

        public Map<String, ?> fields() {
            return this.fields;
        }
    }

    public static final class MockContext
    implements SpanContext {
        private final long traceId;
        private final Map<String, String> baggage;
        private final long spanId;

        public MockContext(long traceId, long spanId, Map<String, String> baggage) {
            this.baggage = baggage;
            this.traceId = traceId;
            this.spanId = spanId;
        }

        public String getBaggageItem(String key) {
            return this.baggage.get(key);
        }

        public long traceId() {
            return this.traceId;
        }

        public long spanId() {
            return this.spanId;
        }

        public MockContext withBaggageItem(String key, String val) {
            HashMap<String, String> newBaggage = new HashMap<String, String>(this.baggage);
            newBaggage.put(key, val);
            return new MockContext(this.traceId, this.spanId, newBaggage);
        }

        public Iterable<Map.Entry<String, String>> baggageItems() {
            return this.baggage.entrySet();
        }
    }
}

