/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.aft;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;

public class InvocationStatDimension {
    private final ProviderInfo providerInfo;
    private final ConsumerConfig consumerConfig;
    private transient String dimensionKey;
    private transient Integer originWeight;

    public InvocationStatDimension(ProviderInfo providerInfo, ConsumerConfig consumerConfig) {
        this.providerInfo = providerInfo;
        this.consumerConfig = consumerConfig;
    }

    public ConsumerConfig getConsumerConfig() {
        return this.consumerConfig;
    }

    public ProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    public String getAppName() {
        return this.consumerConfig.getAppName();
    }

    public String getService() {
        return this.consumerConfig.getInterfaceId();
    }

    public String getIp() {
        return this.providerInfo.getHost();
    }

    public int getOriginWeight() {
        if (this.originWeight == null) {
            this.originWeight = this.providerInfo == null ? Integer.valueOf(RpcConfigs.getIntValue("provider.weight")) : Integer.valueOf(CommonUtils.parseInt(this.providerInfo.getStaticAttr("weight"), RpcConfigs.getIntValue("provider.weight")));
        }
        return this.originWeight;
    }

    public String getDimensionKey() {
        if (this.dimensionKey == null) {
            this.dimensionKey = this.getAppName() + ":" + this.getService();
        }
        return this.dimensionKey;
    }

    public String toString() {
        return (this.consumerConfig != null ? this.consumerConfig.buildKey() : "") + "#" + this.providerInfo.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvocationStatDimension that = (InvocationStatDimension)o;
        if (this.providerInfo != null ? !this.providerInfo.equals(that.providerInfo) : that.providerInfo != null) {
            return false;
        }
        return this.consumerConfig != null ? this.consumerConfig.equals(that.consumerConfig) : that.consumerConfig == null;
    }

    public int hashCode() {
        int result = this.providerInfo != null ? this.providerInfo.hashCode() : 0;
        result = 31 * result + (this.consumerConfig != null ? this.consumerConfig.hashCode() : 0);
        return result;
    }
}

