/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.util;

public class IntArrayList {
    private int size = 0;
    private int[] items;

    public IntArrayList() {
        this(6);
    }

    public IntArrayList(int opacity) {
        if (opacity <= 0) {
            throw new IndexOutOfBoundsException("opacity <= 0");
        }
        this.items = new int[opacity];
    }

    private void resize(int size) {
        int[] tmp = this.items;
        this.items = new int[size];
        int length = size > tmp.length ? tmp.length : size;
        System.arraycopy(tmp, 0, this.items, 0, length);
    }

    public void add(int val) {
        if (this.size == this.items.length) {
            this.resize(this.items.length * 2 + 1);
        }
        this.items[this.size++] = val;
    }

    public int get(int idx) {
        if (idx < 0 || idx > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.items[idx];
    }

    public void set(int idx, int val) {
        if (idx < 0 || idx > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.items[idx] = val;
    }

    public void remove(int idx) {
        if (idx < 0 || idx > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int numMove = this.size - idx - 1;
        if (numMove > 0) {
            System.arraycopy(this.items, idx + 1, this.items, idx, numMove);
        }
        --this.size;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }
}

