/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.UpdatedMetaDataTracker;
import org.slf4j.Logger;

public interface MessageHandler {
    public List<Task<? extends Serializable>> handle(Context var1) throws SemanticException;

    public Set<ReadEntity> readEntities();

    public Set<WriteEntity> writeEntities();

    public UpdatedMetaDataTracker getUpdatedMetadata();

    public static class Context {
        public String dbName;
        public final String tableName;
        public final String location;
        public final Task<? extends Serializable> precursor;
        public DumpMetaData dmd;
        final HiveConf hiveConf;
        final Hive db;
        final org.apache.hadoop.hive.ql.Context nestedContext;
        final Logger log;

        public Context(String dbName, String tableName, String location, Task<? extends Serializable> precursor, DumpMetaData dmd, HiveConf hiveConf, Hive db, org.apache.hadoop.hive.ql.Context nestedContext, Logger log) {
            this.dbName = dbName;
            this.tableName = tableName;
            this.location = location;
            this.precursor = precursor;
            this.dmd = dmd;
            this.hiveConf = hiveConf;
            this.db = db;
            this.nestedContext = nestedContext;
            this.log = log;
        }

        public Context(Context other, String dbName, String tableName) {
            this.dbName = dbName;
            this.tableName = tableName;
            this.location = other.location;
            this.precursor = other.precursor;
            this.dmd = other.dmd;
            this.hiveConf = other.hiveConf;
            this.db = other.db;
            this.nestedContext = other.nestedContext;
            this.log = other.log;
        }

        boolean isTableNameEmpty() {
            return StringUtils.isEmpty(this.tableName);
        }

        public boolean isDbNameEmpty() {
            return StringUtils.isEmpty(this.dbName);
        }

        ReplicationSpec eventOnlyReplicationSpec() throws SemanticException {
            String eventId = this.dmd.getEventTo().toString();
            return new ReplicationSpec(eventId, eventId);
        }

        public org.apache.hadoop.hive.ql.Context getNestedContext() {
            return this.nestedContext;
        }

        public HiveTxnManager getTxnMgr() {
            return this.nestedContext.getHiveTxnManager();
        }
    }
}

