/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CachePoolIterator
extends BatchedRemoteIterator<String, CachePoolEntry> {
    private final ClientProtocol namenode;
    private final Tracer tracer;

    public CachePoolIterator(ClientProtocol namenode, Tracer tracer) {
        super((Object)"");
        this.namenode = namenode;
        this.tracer = tracer;
    }

    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> makeRequest(String prevKey) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("listCachePools");){
            BatchedRemoteIterator.BatchedEntries<CachePoolEntry> batchedEntries = this.namenode.listCachePools(prevKey);
            return batchedEntries;
        }
    }

    public String elementToPrevKey(CachePoolEntry entry) {
        return entry.getInfo().getPoolName();
    }
}

