/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.types.CopyOnWriteArrayMap;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetaCache {
    private static final Logger LOG = LoggerFactory.getLogger(MetaCache.class);
    private final ConcurrentMap<TableName, ConcurrentNavigableMap<byte[], RegionLocations>> cachedRegionLocations = new CopyOnWriteArrayMap();
    private final Set<ServerName> cachedServers = new CopyOnWriteArraySet<ServerName>();
    private final MetricsConnection metrics;

    public MetaCache(MetricsConnection metrics) {
        this.metrics = metrics;
    }

    public RegionLocations getCachedLocation(TableName tableName, byte[] row) {
        ConcurrentNavigableMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        Map.Entry e = tableLocations.floorEntry(row);
        if (e == null) {
            if (this.metrics != null) {
                this.metrics.incrMetaCacheMiss();
            }
            return null;
        }
        RegionLocations possibleRegion = (RegionLocations)e.getValue();
        byte[] endKey = possibleRegion.getRegionLocation().getRegion().getEndKey();
        if (Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW) || Bytes.compareTo((byte[])endKey, (int)0, (int)endKey.length, (byte[])row, (int)0, (int)row.length) > 0) {
            if (this.metrics != null) {
                this.metrics.incrMetaCacheHit();
            }
            return possibleRegion;
        }
        if (this.metrics != null) {
            this.metrics.incrMetaCacheMiss();
        }
        return null;
    }

    public void cacheLocation(TableName tableName, ServerName source, HRegionLocation location) {
        boolean isNewCacheEntry;
        assert (source != null);
        byte[] startKey = location.getRegion().getStartKey();
        ConcurrentNavigableMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        RegionLocations locations = new RegionLocations(location);
        RegionLocations oldLocations = tableLocations.putIfAbsent(startKey, locations);
        boolean bl = isNewCacheEntry = oldLocations == null;
        if (isNewCacheEntry) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cached location: " + location);
            }
            this.addToCachedServers(locations);
            return;
        }
        HRegionLocation oldLocation = oldLocations.getRegionLocation(location.getRegion().getReplicaId());
        boolean force = oldLocation != null && oldLocation.getServerName() != null && oldLocation.getServerName().equals((Object)source);
        RegionLocations updatedLocations = oldLocations.updateLocation(location, false, force);
        if (oldLocations != updatedLocations) {
            boolean replaced = tableLocations.replace(startKey, oldLocations, updatedLocations);
            if (replaced && LOG.isTraceEnabled()) {
                LOG.trace("Changed cached location to: " + location);
            }
            this.addToCachedServers(updatedLocations);
        }
    }

    public void cacheLocation(TableName tableName, RegionLocations locations) {
        boolean isNewCacheEntry;
        byte[] startKey = locations.getRegionLocation().getRegion().getStartKey();
        ConcurrentNavigableMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        RegionLocations oldLocation = tableLocations.putIfAbsent(startKey, locations);
        boolean bl = isNewCacheEntry = oldLocation == null;
        if (isNewCacheEntry) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cached location: " + locations);
            }
            this.addToCachedServers(locations);
            return;
        }
        RegionLocations mergedLocation = oldLocation.mergeLocations(locations);
        boolean replaced = tableLocations.replace(startKey, oldLocation, mergedLocation);
        if (replaced && LOG.isTraceEnabled()) {
            LOG.trace("Merged cached locations: " + mergedLocation);
        }
        this.addToCachedServers(locations);
    }

    private void addToCachedServers(RegionLocations locations) {
        for (HRegionLocation loc : locations.getRegionLocations()) {
            if (loc == null) continue;
            this.cachedServers.add(loc.getServerName());
        }
    }

    private ConcurrentNavigableMap<byte[], RegionLocations> getTableLocations(TableName tableName) {
        return (ConcurrentNavigableMap)ConcurrentMapUtils.computeIfAbsent(this.cachedRegionLocations, (Object)tableName, () -> new CopyOnWriteArrayMap(Bytes.BYTES_COMPARATOR));
    }

    public boolean isRegionCached(TableName tableName, byte[] row) {
        RegionLocations location = this.getCachedLocation(tableName, row);
        return location != null;
    }

    public int getNumberOfCachedRegionLocations(TableName tableName) {
        Map tableLocs = (Map)this.cachedRegionLocations.get(tableName);
        if (tableLocs == null) {
            return 0;
        }
        int numRegions = 0;
        for (RegionLocations tableLoc : tableLocs.values()) {
            numRegions += tableLoc.numNonNullElements();
        }
        return numRegions;
    }

    public void clearCache() {
        this.cachedRegionLocations.clear();
        this.cachedServers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(ServerName serverName) {
        if (!this.cachedServers.contains(serverName)) {
            return;
        }
        boolean deletedSomething = false;
        Set<ServerName> set = this.cachedServers;
        synchronized (set) {
            if (!this.cachedServers.contains(serverName)) {
                return;
            }
            for (ConcurrentMap tableLocations : this.cachedRegionLocations.values()) {
                for (Map.Entry e : tableLocations.entrySet()) {
                    RegionLocations updatedLocations;
                    RegionLocations regionLocations = (RegionLocations)e.getValue();
                    if (regionLocations == null || (updatedLocations = regionLocations.removeByServer(serverName)) == regionLocations) continue;
                    if (updatedLocations.isEmpty()) {
                        deletedSomething |= tableLocations.remove(e.getKey(), regionLocations);
                        continue;
                    }
                    deletedSomething |= tableLocations.replace(e.getKey(), regionLocations, updatedLocations);
                }
            }
            this.cachedServers.remove(serverName);
        }
        if (deletedSomething) {
            if (this.metrics != null) {
                this.metrics.incrMetaCacheNumClearServer();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Removed all cached region locations that map to " + serverName);
            }
        }
    }

    public void clearCache(TableName tableName) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Removed all cached region locations for table " + tableName);
        }
        this.cachedRegionLocations.remove(tableName);
    }

    public void clearCache(TableName tableName, byte[] row) {
        byte[] startKey;
        boolean removed;
        ConcurrentNavigableMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        RegionLocations regionLocations = this.getCachedLocation(tableName, row);
        if (regionLocations != null && (removed = tableLocations.remove(startKey = regionLocations.getRegionLocation().getRegion().getStartKey(), regionLocations))) {
            if (this.metrics != null) {
                this.metrics.incrMetaCacheNumClearRegion();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Removed " + regionLocations + " from cache");
            }
        }
    }

    public void clearCache(TableName tableName, byte[] row, int replicaId) {
        HRegionLocation toBeRemoved;
        ConcurrentNavigableMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        RegionLocations regionLocations = this.getCachedLocation(tableName, row);
        if (regionLocations != null && (toBeRemoved = regionLocations.getRegionLocation(replicaId)) != null) {
            RegionLocations updatedLocations = regionLocations.remove(replicaId);
            byte[] startKey = regionLocations.getRegionLocation().getRegion().getStartKey();
            boolean removed = updatedLocations.isEmpty() ? tableLocations.remove(startKey, regionLocations) : tableLocations.replace(startKey, regionLocations, updatedLocations);
            if (removed) {
                if (this.metrics != null) {
                    this.metrics.incrMetaCacheNumClearRegion();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Removed " + toBeRemoved + " from cache");
                }
            }
        }
    }

    public void clearCache(TableName tableName, byte[] row, ServerName serverName) {
        RegionLocations updatedLocations;
        ConcurrentNavigableMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        RegionLocations regionLocations = this.getCachedLocation(tableName, row);
        if (regionLocations != null && (updatedLocations = regionLocations.removeByServer(serverName)) != regionLocations) {
            byte[] startKey = regionLocations.getRegionLocation().getRegion().getStartKey();
            boolean removed = false;
            removed = updatedLocations.isEmpty() ? tableLocations.remove(startKey, regionLocations) : tableLocations.replace(startKey, regionLocations, updatedLocations);
            if (removed) {
                if (this.metrics != null) {
                    this.metrics.incrMetaCacheNumClearRegion();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Removed locations of table: " + tableName + " ,row: " + Bytes.toString((byte[])row) + " mapping to server: " + serverName + " from cache");
                }
            }
        }
    }

    public void clearCache(RegionInfo hri) {
        ConcurrentNavigableMap<byte[], RegionLocations> tableLocations = this.getTableLocations(hri.getTable());
        RegionLocations regionLocations = (RegionLocations)tableLocations.get(hri.getStartKey());
        if (regionLocations != null) {
            boolean removed;
            HRegionLocation oldLocation = regionLocations.getRegionLocation(hri.getReplicaId());
            if (oldLocation == null) {
                return;
            }
            RegionLocations updatedLocations = regionLocations.remove(oldLocation);
            if (updatedLocations != regionLocations && (removed = updatedLocations.isEmpty() ? tableLocations.remove(hri.getStartKey(), regionLocations) : tableLocations.replace(hri.getStartKey(), regionLocations, updatedLocations))) {
                if (this.metrics != null) {
                    this.metrics.incrMetaCacheNumClearRegion();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Removed " + oldLocation + " from cache");
                }
            }
        }
    }

    public void clearCache(HRegionLocation location) {
        boolean removed;
        RegionLocations updatedLocations;
        if (location == null) {
            return;
        }
        TableName tableName = location.getRegion().getTable();
        ConcurrentNavigableMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        RegionLocations regionLocations = (RegionLocations)tableLocations.get(location.getRegion().getStartKey());
        if (regionLocations != null && (updatedLocations = regionLocations.remove(location)) != regionLocations && (removed = updatedLocations.isEmpty() ? tableLocations.remove(location.getRegion().getStartKey(), regionLocations) : tableLocations.replace(location.getRegion().getStartKey(), regionLocations, updatedLocations))) {
            if (this.metrics != null) {
                this.metrics.incrMetaCacheNumClearRegion();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Removed " + location + " from cache");
            }
        }
    }
}

