/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.asm.AsmFactoryProvider;
import org.simpleflatmapper.reflect.getter.FieldGetter;
import org.simpleflatmapper.reflect.getter.GetterHelper;
import org.simpleflatmapper.reflect.getter.MethodGetter;
import org.simpleflatmapper.reflect.primitive.BooleanGetter;
import org.simpleflatmapper.reflect.primitive.BoxedBooleanGetter;
import org.simpleflatmapper.reflect.primitive.BoxedByteGetter;
import org.simpleflatmapper.reflect.primitive.BoxedCharacterGetter;
import org.simpleflatmapper.reflect.primitive.BoxedDoubleGetter;
import org.simpleflatmapper.reflect.primitive.BoxedFloatGetter;
import org.simpleflatmapper.reflect.primitive.BoxedIntGetter;
import org.simpleflatmapper.reflect.primitive.BoxedLongGetter;
import org.simpleflatmapper.reflect.primitive.BoxedShortGetter;
import org.simpleflatmapper.reflect.primitive.ByteGetter;
import org.simpleflatmapper.reflect.primitive.CharacterGetter;
import org.simpleflatmapper.reflect.primitive.DoubleGetter;
import org.simpleflatmapper.reflect.primitive.FloatGetter;
import org.simpleflatmapper.reflect.primitive.IntGetter;
import org.simpleflatmapper.reflect.primitive.LongGetter;
import org.simpleflatmapper.reflect.primitive.ShortGetter;
import org.simpleflatmapper.util.Asserts;

public final class ObjectGetterFactory {
    private final AsmFactoryProvider asmFactory;

    public ObjectGetterFactory(AsmFactoryProvider asmFactory) {
        this.asmFactory = asmFactory;
    }

    public <T, P> Getter<T, P> getGetter(Class<? super T> target, String property) {
        Method method = this.lookForMethod(target, property);
        Getter<T, P> getter = method == null ? this.getFieldGetter(target, property) : this.getMethodGetter(method);
        return getter;
    }

    public <T, P> Getter<T, P> getMethodGetter(Method method) {
        boolean accessible;
        boolean bl = accessible = Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers());
        if (this.asmFactory != null && accessible) {
            try {
                return this.asmFactory.getAsmFactory(method.getDeclaringClass().getClassLoader()).createGetter(method);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!accessible) {
            try {
                method.setAccessible(true);
            }
            catch (Exception e) {
                return null;
            }
        }
        return new MethodGetter(method);
    }

    public <T, P> Getter<T, P> getFieldGetter(Class<?> target, String property) {
        Field field = this.lookForField(target, property);
        if (field != null) {
            return this.getFieldGetter(field);
        }
        return null;
    }

    public <T, P> Getter<T, P> getFieldGetter(Field field) {
        boolean accessible;
        Asserts.requireNonNull((String)"field", (Object)field);
        boolean bl = accessible = Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers());
        if (this.asmFactory != null && accessible) {
            try {
                AsmFactory asmFactory = this.asmFactory.getAsmFactory(field.getDeclaringClass().getClassLoader());
                if (asmFactory != null) {
                    return asmFactory.createGetter(field);
                }
            }
            catch (Throwable asmFactory) {
                // empty catch block
            }
        }
        if (!accessible) {
            try {
                field.setAccessible(true);
            }
            catch (Exception e) {
                return null;
            }
        }
        return new FieldGetter(field);
    }

    private Method lookForMethod(Class<?> target, String property) {
        if (target == null) {
            return null;
        }
        for (Method m : target.getDeclaredMethods()) {
            if (!GetterHelper.isPublicMember(m.getModifiers()) || !GetterHelper.methodNameMatchesProperty(m.getName(), property)) continue;
            return m;
        }
        if (!Object.class.equals(target)) {
            return this.lookForMethod(target.getSuperclass(), property);
        }
        return null;
    }

    private Field lookForField(Class<?> target, String property) {
        if (target == null) {
            return null;
        }
        for (Field field : target.getDeclaredFields()) {
            if (!GetterHelper.fieldModifiersMatches(field.getModifiers()) || !GetterHelper.fieldNameMatchesProperty(field.getName(), property)) continue;
            return field;
        }
        return this.lookForField(target.getSuperclass(), property);
    }

    public static <T> BooleanGetter<T> toBooleanGetter(Getter<T, ? extends Boolean> getter) {
        if (getter instanceof BooleanGetter) {
            return (BooleanGetter)((Object)getter);
        }
        return new BoxedBooleanGetter<T>(getter);
    }

    public static <T> IntGetter<T> toIntGetter(Getter<T, ? extends Integer> getter) {
        if (getter instanceof IntGetter) {
            return (IntGetter)((Object)getter);
        }
        return new BoxedIntGetter<T>(getter);
    }

    public static <T> LongGetter<T> toLongGetter(Getter<T, ? extends Long> getter) {
        if (getter instanceof LongGetter) {
            return (LongGetter)((Object)getter);
        }
        return new BoxedLongGetter<T>(getter);
    }

    public static <T> FloatGetter<T> toFloatGetter(Getter<T, ? extends Float> getter) {
        if (getter instanceof FloatGetter) {
            return (FloatGetter)((Object)getter);
        }
        return new BoxedFloatGetter<T>(getter);
    }

    public static <T> DoubleGetter<T> toDoubleGetter(Getter<T, ? extends Double> getter) {
        if (getter instanceof DoubleGetter) {
            return (DoubleGetter)((Object)getter);
        }
        return new BoxedDoubleGetter<T>(getter);
    }

    public static <T> ByteGetter<T> toByteGetter(Getter<T, ? extends Byte> getter) {
        if (getter instanceof ByteGetter) {
            return (ByteGetter)((Object)getter);
        }
        return new BoxedByteGetter<T>(getter);
    }

    public static <T> ShortGetter<T> toShortGetter(Getter<T, ? extends Short> getter) {
        if (getter instanceof ShortGetter) {
            return (ShortGetter)((Object)getter);
        }
        return new BoxedShortGetter<T>(getter);
    }

    public static <T> CharacterGetter<T> toCharGetter(Getter<T, ? extends Character> getter) {
        if (getter instanceof CharacterGetter) {
            return (CharacterGetter)((Object)getter);
        }
        return new BoxedCharacterGetter<T>(getter);
    }
}

