/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.entity.schema.ConflictCheckEntity;
import org.apache.hugegraph.entity.schema.ConflictDetail;
import org.apache.hugegraph.entity.schema.ConflictStatus;
import org.apache.hugegraph.entity.schema.PropertyKeyEntity;
import org.apache.hugegraph.entity.schema.SchemaConflict;
import org.apache.hugegraph.entity.schema.SchemaEntity;
import org.apache.hugegraph.entity.schema.SchemaType;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.service.schema.SchemaService;
import org.apache.hugegraph.structure.SchemaElement;
import org.apache.hugegraph.structure.schema.EdgeLabel;
import org.apache.hugegraph.structure.schema.PropertyKey;
import org.apache.hugegraph.structure.schema.VertexLabel;
import org.apache.hugegraph.util.Ex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PropertyKeyService
extends SchemaService {
    private static final Logger log = LogManager.getLogger(PropertyKeyService.class);

    public List<PropertyKeyEntity> list(int connId) {
        return this.list(Collections.emptyList(), connId);
    }

    public List<PropertyKeyEntity> list(Collection<String> names, int connId) {
        return this.list(names, connId, true);
    }

    public List<PropertyKeyEntity> list(Collection<String> names, int connId, boolean emptyAsAll) {
        HugeClient client = this.client(connId);
        List propertyKeys = CollectionUtils.isEmpty(names) ? (emptyAsAll ? client.schema().getPropertyKeys() : new ArrayList()) : client.schema().getPropertyKeys(new ArrayList<String>(names));
        ArrayList<PropertyKeyEntity> results = new ArrayList<PropertyKeyEntity>(propertyKeys.size());
        propertyKeys.forEach(propertyKey -> results.add(PropertyKeyService.convert(propertyKey)));
        return results;
    }

    public PropertyKeyEntity get(String name, int connId) {
        HugeClient client = this.client(connId);
        try {
            PropertyKey propertyKey = client.schema().getPropertyKey(name);
            return PropertyKeyService.convert(propertyKey);
        }
        catch (ServerException e) {
            if (e.status() == 404) {
                throw new ExternalException("schema.propertykey.not-exist", (Throwable)e, name);
            }
            throw new ExternalException("schema.propertykey.get.failed", (Throwable)e, name);
        }
    }

    public void checkExist(String name, int connId) {
        this.get(name, connId);
    }

    public void checkNotExist(String name, int connId) {
        try {
            this.get(name, connId);
        }
        catch (ExternalException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ServerException && ((ServerException)cause).status() == 404) {
                return;
            }
            throw e;
        }
        throw new ExternalException("schema.propertykey.exist", name);
    }

    public void add(PropertyKeyEntity entity, int connId) {
        HugeClient client = this.client(connId);
        PropertyKey propertyKey = PropertyKeyService.convert(entity, client);
        client.schema().addPropertyKey(propertyKey);
    }

    public void remove(String name, int connId) {
        HugeClient client = this.client(connId);
        client.schema().removePropertyKey(name);
    }

    public boolean checkUsing(String name, int connId) {
        HugeClient client = this.client(connId);
        List vertexLabels = client.schema().getVertexLabels();
        for (VertexLabel vertexLabel : vertexLabels) {
            if (!vertexLabel.properties().contains(name)) continue;
            return true;
        }
        List edgeLabels = client.schema().getEdgeLabels();
        for (EdgeLabel edgeLabel : edgeLabels) {
            if (!edgeLabel.properties().contains(name)) continue;
            return true;
        }
        return false;
    }

    public ConflictDetail checkConflict(ConflictCheckEntity entity, int connId, boolean compareEachOther) {
        ConflictDetail detail = new ConflictDetail(SchemaType.PROPERTY_KEY);
        if (CollectionUtils.isEmpty(entity.getPkEntities())) {
            return detail;
        }
        this.checkConflict(entity.getPkEntities(), detail, connId, compareEachOther);
        return detail;
    }

    public void checkConflict(List<PropertyKeyEntity> entities, ConflictDetail detail, int connId, boolean compareEachOther) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        HashMap<String, PropertyKeyEntity> originEntities = new HashMap<String, PropertyKeyEntity>();
        for (PropertyKeyEntity entity : this.list(connId)) {
            originEntities.put(entity.getName(), entity);
        }
        for (PropertyKeyEntity entity : entities) {
            PropertyKeyEntity originEntity = (PropertyKeyEntity)originEntities.get(entity.getName());
            ConflictStatus status = SchemaEntity.compare(entity, originEntity);
            detail.add(entity, status);
        }
        if (compareEachOther) {
            PropertyKeyService.compareWithEachOther(detail, SchemaType.PROPERTY_KEY);
        }
    }

    public void reuse(ConflictDetail detail, int connId) {
        Ex.check(!detail.hasConflict(), "schema.cannot-reuse-conflict", new Object[0]);
        HugeClient client = this.client(connId);
        List<PropertyKey> propertyKeys = this.filter(detail, client);
        if (propertyKeys.isEmpty()) {
            return;
        }
        try {
            this.addBatch(propertyKeys, client);
        }
        catch (Exception e) {
            throw new ExternalException("schema.propertykey.reuse.failed", (Throwable)e, new Object[0]);
        }
    }

    public List<PropertyKey> filter(ConflictDetail detail, HugeClient client) {
        return detail.getPkConflicts().stream().filter(c -> c.getStatus() == ConflictStatus.PASSED).map(SchemaConflict::getEntity).map(e -> PropertyKeyService.convert(e, client)).collect(Collectors.toList());
    }

    public void addBatch(List<PropertyKey> propertyKeys, HugeClient client) {
        BiConsumer<HugeClient, PropertyKey> consumer = (hugeClient, pk) -> hugeClient.schema().addPropertyKey(pk);
        PropertyKeyService.addBatch(propertyKeys, client, consumer, SchemaType.PROPERTY_KEY);
    }

    public void removeBatch(List<PropertyKey> propertyKeys, HugeClient client) {
        List<String> names = PropertyKeyService.collectNames(propertyKeys);
        BiConsumer<HugeClient, String> consumer = (hugeClient, name) -> hugeClient.schema().removePropertyKey(name);
        PropertyKeyService.removeBatch(names, client, consumer, SchemaType.PROPERTY_KEY);
    }

    public static PropertyKeyEntity convert(PropertyKey propertyKey) {
        if (propertyKey == null) {
            return null;
        }
        return PropertyKeyEntity.builder().name(propertyKey.name()).dataType(propertyKey.dataType()).cardinality(propertyKey.cardinality()).createTime(PropertyKeyService.getCreateTime((SchemaElement)propertyKey)).build();
    }

    public static PropertyKey convert(PropertyKeyEntity entity, HugeClient client) {
        if (entity == null) {
            return null;
        }
        return (PropertyKey)client.schema().propertyKey(entity.getName()).dataType(entity.getDataType()).cardinality(entity.getCardinality()).userdata("~create_time", (Object)entity.getCreateTime()).build();
    }
}

