/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.StripedBlockInfo;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.Op;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.htrace.core.SpanId;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class Receiver
implements DataTransferProtocol {
    private final Tracer tracer;
    protected DataInputStream in;

    protected Receiver(Tracer tracer) {
        this.tracer = tracer;
    }

    protected void initialize(DataInputStream in) {
        this.in = in;
    }

    protected final Op readOp() throws IOException {
        short version = this.in.readShort();
        if (version != 28) {
            throw new IOException("Version Mismatch (Expected: 28, Received: " + version + " )");
        }
        return Op.read((DataInput)this.in);
    }

    private TraceScope continueTraceSpan(DataTransferProtos.DataTransferTraceInfoProto proto, String description) {
        TraceScope scope = null;
        SpanId spanId = DataTransferProtoUtil.fromProto((DataTransferProtos.DataTransferTraceInfoProto)proto);
        if (spanId != null) {
            scope = this.tracer.newScope(description, spanId);
        }
        return scope;
    }

    private TraceScope continueTraceSpan(DataTransferProtos.ClientOperationHeaderProto header, String description) {
        return this.continueTraceSpan(header.getBaseHeader(), description);
    }

    private TraceScope continueTraceSpan(DataTransferProtos.BaseHeaderProto header, String description) {
        return this.continueTraceSpan(header.getTraceInfo(), description);
    }

    protected final void processOp(Op op) throws IOException {
        switch (op) {
            case READ_BLOCK: {
                this.opReadBlock();
                break;
            }
            case WRITE_BLOCK: {
                this.opWriteBlock(this.in);
                break;
            }
            case REPLACE_BLOCK: {
                this.opReplaceBlock(this.in);
                break;
            }
            case COPY_BLOCK: {
                this.opCopyBlock(this.in);
                break;
            }
            case BLOCK_CHECKSUM: {
                this.opBlockChecksum(this.in);
                break;
            }
            case BLOCK_GROUP_CHECKSUM: {
                this.opStripedBlockChecksum(this.in);
                break;
            }
            case TRANSFER_BLOCK: {
                this.opTransferBlock(this.in);
                break;
            }
            case REQUEST_SHORT_CIRCUIT_FDS: {
                this.opRequestShortCircuitFds(this.in);
                break;
            }
            case RELEASE_SHORT_CIRCUIT_FDS: {
                this.opReleaseShortCircuitFds(this.in);
                break;
            }
            case REQUEST_SHORT_CIRCUIT_SHM: {
                this.opRequestShortCircuitShm(this.in);
                break;
            }
            default: {
                throw new IOException("Unknown op " + op + " in data stream");
            }
        }
    }

    private static CachingStrategy getCachingStrategy(DataTransferProtos.CachingStrategyProto strategy) {
        Boolean dropBehind = strategy.hasDropBehind() ? Boolean.valueOf(strategy.getDropBehind()) : null;
        Long readahead = strategy.hasReadahead() ? Long.valueOf(strategy.getReadahead()) : null;
        return new CachingStrategy(dropBehind, readahead);
    }

    private void opReadBlock() throws IOException {
        DataTransferProtos.OpReadBlockProto proto = DataTransferProtos.OpReadBlockProto.parseFrom((InputStream)PBHelperClient.vintPrefixed((InputStream)this.in));
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.readBlock(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)proto.getHeader().getBaseHeader().getBlock()), PBHelperClient.convert((SecurityProtos.TokenProto)proto.getHeader().getBaseHeader().getToken()), proto.getHeader().getClientName(), proto.getOffset(), proto.getLen(), proto.getSendChecksums(), proto.hasCachingStrategy() ? Receiver.getCachingStrategy(proto.getCachingStrategy()) : CachingStrategy.newDefaultStrategy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opWriteBlock(DataInputStream in) throws IOException {
        DataTransferProtos.OpWriteBlockProto proto = DataTransferProtos.OpWriteBlockProto.parseFrom((InputStream)PBHelperClient.vintPrefixed((InputStream)in));
        DatanodeInfo[] targets = PBHelperClient.convert((List)proto.getTargetsList());
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.writeBlock(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)proto.getHeader().getBaseHeader().getBlock()), PBHelperClient.convertStorageType((HdfsProtos.StorageTypeProto)proto.getStorageType()), PBHelperClient.convert((SecurityProtos.TokenProto)proto.getHeader().getBaseHeader().getToken()), proto.getHeader().getClientName(), targets, PBHelperClient.convertStorageTypes((List)proto.getTargetStorageTypesList(), (int)targets.length), PBHelperClient.convert((HdfsProtos.DatanodeInfoProto)proto.getSource()), DataTransferProtoUtil.fromProto((DataTransferProtos.OpWriteBlockProto.BlockConstructionStage)proto.getStage()), proto.getPipelineSize(), proto.getMinBytesRcvd(), proto.getMaxBytesRcvd(), proto.getLatestGenerationStamp(), DataTransferProtoUtil.fromProto((DataTransferProtos.ChecksumProto)proto.getRequestedChecksum()), proto.hasCachingStrategy() ? Receiver.getCachingStrategy(proto.getCachingStrategy()) : CachingStrategy.newDefaultStrategy(), proto.hasAllowLazyPersist() ? proto.getAllowLazyPersist() : false, proto.hasPinning() ? proto.getPinning() : false, PBHelperClient.convertBooleanList((List)proto.getTargetPinningsList()), proto.getStorageId(), (String[])proto.getTargetStorageIdsList().toArray((Object[])new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opTransferBlock(DataInputStream in) throws IOException {
        DataTransferProtos.OpTransferBlockProto proto = DataTransferProtos.OpTransferBlockProto.parseFrom((InputStream)PBHelperClient.vintPrefixed((InputStream)in));
        DatanodeInfo[] targets = PBHelperClient.convert((List)proto.getTargetsList());
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            ExtendedBlock block = PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)proto.getHeader().getBaseHeader().getBlock());
            StorageType[] targetStorageTypes = PBHelperClient.convertStorageTypes((List)proto.getTargetStorageTypesList(), (int)targets.length);
            this.transferBlock(block, PBHelperClient.convert((SecurityProtos.TokenProto)proto.getHeader().getBaseHeader().getToken()), proto.getHeader().getClientName(), targets, targetStorageTypes, (String[])proto.getTargetStorageIdsList().toArray((Object[])new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opRequestShortCircuitFds(DataInputStream in) throws IOException {
        DataTransferProtos.OpRequestShortCircuitAccessProto proto = DataTransferProtos.OpRequestShortCircuitAccessProto.parseFrom((InputStream)PBHelperClient.vintPrefixed((InputStream)in));
        ShortCircuitShm.SlotId slotId = proto.hasSlotId() ? PBHelperClient.convert((DataTransferProtos.ShortCircuitShmSlotProto)proto.getSlotId()) : null;
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.requestShortCircuitFds(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)proto.getHeader().getBlock()), PBHelperClient.convert((SecurityProtos.TokenProto)proto.getHeader().getToken()), slotId, proto.getMaxVersion(), proto.getSupportsReceiptVerification());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opReleaseShortCircuitFds(DataInputStream in) throws IOException {
        DataTransferProtos.ReleaseShortCircuitAccessRequestProto proto = DataTransferProtos.ReleaseShortCircuitAccessRequestProto.parseFrom((InputStream)PBHelperClient.vintPrefixed((InputStream)in));
        try (TraceScope traceScope = this.continueTraceSpan(proto.getTraceInfo(), proto.getClass().getSimpleName());){
            this.releaseShortCircuitFds(PBHelperClient.convert((DataTransferProtos.ShortCircuitShmSlotProto)proto.getSlotId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opRequestShortCircuitShm(DataInputStream in) throws IOException {
        DataTransferProtos.ShortCircuitShmRequestProto proto = DataTransferProtos.ShortCircuitShmRequestProto.parseFrom((InputStream)PBHelperClient.vintPrefixed((InputStream)in));
        try (TraceScope traceScope = this.continueTraceSpan(proto.getTraceInfo(), proto.getClass().getSimpleName());){
            this.requestShortCircuitShm(proto.getClientName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opReplaceBlock(DataInputStream in) throws IOException {
        DataTransferProtos.OpReplaceBlockProto proto = DataTransferProtos.OpReplaceBlockProto.parseFrom((InputStream)PBHelperClient.vintPrefixed((InputStream)in));
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.replaceBlock(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)proto.getHeader().getBlock()), PBHelperClient.convertStorageType((HdfsProtos.StorageTypeProto)proto.getStorageType()), PBHelperClient.convert((SecurityProtos.TokenProto)proto.getHeader().getToken()), proto.getDelHint(), PBHelperClient.convert((HdfsProtos.DatanodeInfoProto)proto.getSource()), proto.getStorageId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opCopyBlock(DataInputStream in) throws IOException {
        DataTransferProtos.OpCopyBlockProto proto = DataTransferProtos.OpCopyBlockProto.parseFrom((InputStream)PBHelperClient.vintPrefixed((InputStream)in));
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.copyBlock(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)proto.getHeader().getBlock()), PBHelperClient.convert((SecurityProtos.TokenProto)proto.getHeader().getToken()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opBlockChecksum(DataInputStream in) throws IOException {
        DataTransferProtos.OpBlockChecksumProto proto = DataTransferProtos.OpBlockChecksumProto.parseFrom((InputStream)PBHelperClient.vintPrefixed((InputStream)in));
        try (TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());){
            this.blockChecksum(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)proto.getHeader().getBlock()), PBHelperClient.convert((SecurityProtos.TokenProto)proto.getHeader().getToken()), PBHelperClient.convert((HdfsProtos.BlockChecksumOptionsProto)proto.getBlockChecksumOptions()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opStripedBlockChecksum(DataInputStream dis) throws IOException {
        DataTransferProtos.OpBlockGroupChecksumProto proto = DataTransferProtos.OpBlockGroupChecksumProto.parseFrom((InputStream)PBHelperClient.vintPrefixed((InputStream)dis));
        TraceScope traceScope = this.continueTraceSpan(proto.getHeader(), proto.getClass().getSimpleName());
        StripedBlockInfo stripedBlockInfo = new StripedBlockInfo(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)proto.getHeader().getBlock()), PBHelperClient.convert((HdfsProtos.DatanodeInfosProto)proto.getDatanodes()), PBHelperClient.convertTokens((List)proto.getBlockTokensList()), PBHelperClient.convertBlockIndices((List)proto.getBlockIndicesList()), PBHelperClient.convertErasureCodingPolicy((HdfsProtos.ErasureCodingPolicyProto)proto.getEcPolicy()));
        try {
            this.blockGroupChecksum(stripedBlockInfo, PBHelperClient.convert((SecurityProtos.TokenProto)proto.getHeader().getToken()), proto.getRequestedNumBytes(), PBHelperClient.convert((HdfsProtos.BlockChecksumOptionsProto)proto.getBlockChecksumOptions()));
        }
        finally {
            if (traceScope != null) {
                traceScope.close();
            }
        }
    }
}

