/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.cmd;

import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.OptionSpace;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.dist.RegisterUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class ConfDumper {
    public static final String EOL = System.getProperty("line.separator");
    private static final Logger LOG = Log.logger(ConfDumper.class);

    public static void main(String[] args) throws ConfigurationException, IOException {
        E.checkArgument((args.length == 1 ? 1 : 0) != 0, (String)"ConfDumper need a config file.", (Object[])new Object[0]);
        String input = args[0];
        File output = new File(input + ".default");
        LOG.info("Input config: {}", (Object)input);
        LOG.info("Output config: {}", (Object)output.getPath());
        RegisterUtil.registerBackends();
        RegisterUtil.registerServer();
        HugeConfig config = new HugeConfig(input);
        for (String name : new TreeSet(OptionSpace.keys())) {
            TypedOption option = OptionSpace.get((String)name);
            ConfDumper.writeOption(output, option, config.get(option));
        }
    }

    private static void writeOption(File output, TypedOption<?, ?> option, Object value) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("# ").append(option.desc()).append(EOL);
        sb.append(option.name()).append("=").append(value).append(EOL);
        sb.append(EOL);
        FileUtils.write((File)output, (CharSequence)sb.toString(), (boolean)true);
    }
}

