/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.palo;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import okhttp3.Response;
import org.apache.hugegraph.backend.store.palo.PaloOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.rest.AbstractRestClient;
import org.apache.hugegraph.rest.RestClient;
import org.apache.hugegraph.rest.RestHeaders;

public class PaloHttpClient {
    private final RestClient client;

    public PaloHttpClient(HugeConfig config, String database) {
        String url = this.buildUrl(config, database);
        String username = (String)config.get(PaloOptions.PALO_USERNAME);
        String password = (String)config.get(PaloOptions.PALO_PASSWORD);
        Integer timeout = (Integer)config.get(PaloOptions.PALO_HTTP_TIMEOUT);
        this.client = new Client(url, username, password, timeout);
    }

    private String buildUrl(HugeConfig config, String database) {
        String host = (String)config.get(PaloOptions.PALO_HOST);
        Integer port = (Integer)config.get(PaloOptions.PALO_HTTP_PORT);
        return String.format("http://%s:%s/api/%s/", host, port, database);
    }

    public void bulkLoadAsync(String table, String body, String label) {
        String path = table + "/_load";
        RestHeaders headers = new RestHeaders();
        headers.add("Expect", "100-continue");
        ImmutableMap params = ImmutableMap.of((Object)"label", (Object)label);
        this.client.put(path, body, (Object)headers, (Map)params);
    }

    private static class Client
    extends AbstractRestClient {
        private static final int SECOND = 1000;

        public Client(String url, String user, String password, int timeout) {
            super(url, user, password, timeout * 1000);
        }

        protected void checkStatus(Response response, int ... statuses) {
        }
    }
}

