/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import org.eclipse.collections.api.factory.primitive.ObjectIntMaps;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.impl.bag.mutable.AbstractHashBag;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.Iterate;

public class HashBag<T>
extends AbstractHashBag<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;

    public HashBag() {
        this.items = ObjectIntMaps.mutable.empty();
    }

    public HashBag(int size) {
        this.items = ObjectIntMaps.mutable.withInitialCapacity(size);
    }

    private HashBag(MutableObjectIntMap<T> map) {
        this.items = map;
        this.size = (int)map.sum();
    }

    public static <E> HashBag<E> newBag() {
        return new HashBag();
    }

    public static <E> HashBag<E> newBag(int size) {
        return new HashBag(size);
    }

    public static <E> HashBag<E> newBag(Bag<? extends E> source) {
        HashBag<E> result = HashBag.newBag(source.sizeDistinct());
        result.addAllBag(source);
        return result;
    }

    public static <E> HashBag<E> newBag(Iterable<? extends E> source) {
        if (source instanceof Bag) {
            return HashBag.newBag((Bag)source);
        }
        return HashBag.newBagWith(Iterate.toArray(source));
    }

    public static <E> HashBag<E> newBagWith(E ... elements) {
        HashBag<E> result = HashBag.newBag();
        ArrayIterate.addAllTo(elements, result);
        return result;
    }

    @Override
    protected int computeHashCode(T item) {
        return item.hashCode();
    }

    public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
        MutableObjectIntMap map = this.items.select((ObjectIntPredicate & Serializable)(each, occurrences) -> predicate.accept(occurrences));
        return new HashBag<T>(map);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ((Externalizable)this.items).writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.items = ObjectIntMaps.mutable.empty();
        ((Externalizable)this.items).readExternal(in);
        this.size = (int)this.items.sum();
    }

    public HashBag<T> without(T element) {
        this.remove(element);
        return this;
    }

    public MutableBag<T> newEmpty() {
        return HashBag.newBag();
    }

    public HashBag<T> with(T element) {
        this.add(element);
        return this;
    }

    public HashBag<T> withAll(Iterable<? extends T> iterable) {
        this.addAllIterable(iterable);
        return this;
    }

    public HashBag<T> withoutAll(Iterable<? extends T> iterable) {
        this.removeAllIterable(iterable);
        return this;
    }

    public HashBag<T> with(T ... elements) {
        this.addAll(Arrays.asList(elements));
        return this;
    }

    public HashBag<T> with(T element1, T element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public HashBag<T> with(T element1, T element2, T element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }
}

