/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service;

import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.entity.GraphConnection;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.options.HubbleOptions;
import org.apache.hugegraph.service.GraphConnectionService;
import org.apache.hugegraph.service.SettingSSLService;
import org.apache.hugegraph.util.HugeClientUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class HugeClientPoolService
extends ConcurrentHashMap<Integer, HugeClient> {
    private static final Logger log = LogManager.getLogger(HugeClientPoolService.class);
    @Autowired
    private HugeConfig config;
    @Autowired
    private GraphConnectionService connService;
    @Autowired
    private SettingSSLService sslService;

    @PreDestroy
    public void destroy() {
        log.info("Destroy HugeClient pool");
        for (HugeClient client : this.values()) {
            client.close();
        }
    }

    @Override
    public void put(GraphConnection connection, HugeClient client) {
        super.put(connection.getId(), client);
    }

    public synchronized HugeClient getOrCreate(Integer id) {
        HugeClient client = (HugeClient)super.get(id);
        if (client != null) {
            return client;
        }
        GraphConnection connection = this.connService.get(id);
        if (connection == null) {
            throw new ExternalException("graph-connection.get.failed", id);
        }
        if (connection.getTimeout() == null) {
            int timeout = (Integer)this.config.get(HubbleOptions.CLIENT_REQUEST_TIMEOUT);
            connection.setTimeout(timeout);
        }
        this.sslService.configSSL(this.config, connection);
        client = HugeClientUtil.tryConnect(connection);
        this.put(id, client);
        return client;
    }

    public void remove(GraphConnection connection) {
        HugeClient client = (HugeClient)super.remove(connection.getId());
        if (client == null) {
            return;
        }
        client.close();
    }
}

