/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.counter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hive.spark.counter.SparkCounter;
import org.apache.spark.api.java.JavaSparkContext;

public class SparkCounterGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String groupName;
    private String groupDisplayName;
    private Map<String, SparkCounter> sparkCounters;
    private transient JavaSparkContext javaSparkContext;

    private SparkCounterGroup() {
    }

    public SparkCounterGroup(String groupName, String groupDisplayName, JavaSparkContext javaSparkContext) {
        this.groupName = groupName;
        this.groupDisplayName = groupDisplayName;
        this.javaSparkContext = javaSparkContext;
        this.sparkCounters = new HashMap<String, SparkCounter>();
    }

    public void createCounter(String name, long initValue) {
        SparkCounter counter = new SparkCounter(name, name, this.groupName, initValue, this.javaSparkContext);
        this.sparkCounters.put(name, counter);
    }

    public SparkCounter getCounter(String name) {
        return this.sparkCounters.get(name);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupDisplayName() {
        return this.groupDisplayName;
    }

    public void setGroupDisplayName(String groupDisplayName) {
        this.groupDisplayName = groupDisplayName;
    }

    public Map<String, SparkCounter> getSparkCounters() {
        return this.sparkCounters;
    }

    SparkCounterGroup snapshot() {
        SparkCounterGroup snapshot = new SparkCounterGroup(this.getGroupName(), this.getGroupDisplayName(), null);
        for (SparkCounter counter : this.sparkCounters.values()) {
            SparkCounter counterSnapshot = counter.snapshot();
            snapshot.sparkCounters.put(counterSnapshot.getName(), counterSnapshot);
        }
        return snapshot;
    }
}

