/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicatorRegistry;
import org.springframework.boot.actuate.health.HealthIndicatorRegistryFactory;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

final class HealthIndicatorRegistryBeans {
    private HealthIndicatorRegistryBeans() {
    }

    public static HealthIndicatorRegistry get(ApplicationContext applicationContext) {
        LinkedHashMap indicators = new LinkedHashMap();
        indicators.putAll(applicationContext.getBeansOfType(HealthIndicator.class));
        if (ClassUtils.isPresent((String)"reactor.core.publisher.Flux", null)) {
            new ReactiveHealthIndicators().get(applicationContext).forEach(indicators::putIfAbsent);
        }
        HealthIndicatorRegistryFactory factory = new HealthIndicatorRegistryFactory();
        return factory.createHealthIndicatorRegistry(indicators);
    }

    private static class ReactiveHealthIndicators {
        private ReactiveHealthIndicators() {
        }

        public Map<String, HealthIndicator> get(ApplicationContext applicationContext) {
            LinkedHashMap<String, HealthIndicator> indicators = new LinkedHashMap<String, HealthIndicator>();
            applicationContext.getBeansOfType(ReactiveHealthIndicator.class).forEach((name, indicator) -> indicators.put((String)name, this.adapt((ReactiveHealthIndicator)indicator)));
            return indicators;
        }

        private HealthIndicator adapt(ReactiveHealthIndicator indicator) {
            return () -> (Health)indicator.health().block();
        }
    }
}

