/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.servlet;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTagsProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.NestedServletException;

public class WebMvcMetricsFilter
extends OncePerRequestFilter {
    private final MeterRegistry registry;
    private final WebMvcTagsProvider tagsProvider;
    private final String metricName;
    private final boolean autoTimeRequests;

    @Deprecated
    public WebMvcMetricsFilter(ApplicationContext context, MeterRegistry registry, WebMvcTagsProvider tagsProvider, String metricName, boolean autoTimeRequests) {
        this(registry, tagsProvider, metricName, autoTimeRequests);
    }

    public WebMvcMetricsFilter(MeterRegistry registry, WebMvcTagsProvider tagsProvider, String metricName, boolean autoTimeRequests) {
        this.registry = registry;
        this.tagsProvider = tagsProvider;
        this.metricName = metricName;
        this.autoTimeRequests = autoTimeRequests;
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.filterAndRecordMetrics(request, response, filterChain);
    }

    private void filterAndRecordMetrics(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        TimingContext timingContext = TimingContext.get(request);
        if (timingContext == null) {
            timingContext = this.startAndAttachTimingContext(request);
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (!request.isAsyncStarted()) {
                Throwable exception = (Throwable)request.getAttribute(DispatcherServlet.EXCEPTION_ATTRIBUTE);
                this.record(timingContext, response, request, exception);
            }
        }
        catch (NestedServletException ex) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            this.record(timingContext, response, request, ex.getCause());
            throw ex;
        }
        catch (IOException | RuntimeException | ServletException ex) {
            this.record(timingContext, response, request, ex);
            throw ex;
        }
    }

    private TimingContext startAndAttachTimingContext(HttpServletRequest request) {
        Timer.Sample timerSample = Timer.start((MeterRegistry)this.registry);
        TimingContext timingContext = new TimingContext(timerSample);
        timingContext.attachTo(request);
        return timingContext;
    }

    private Set<Timed> getTimedAnnotations(Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return Collections.emptySet();
        }
        return this.getTimedAnnotations((HandlerMethod)handler);
    }

    private Set<Timed> getTimedAnnotations(HandlerMethod handler) {
        Set<Timed> timed = this.findTimedAnnotations(handler.getMethod());
        if (timed.isEmpty()) {
            return this.findTimedAnnotations(handler.getBeanType());
        }
        return timed;
    }

    private Set<Timed> findTimedAnnotations(AnnotatedElement element) {
        return AnnotationUtils.getDeclaredRepeatableAnnotations((AnnotatedElement)element, Timed.class);
    }

    private void record(TimingContext timingContext, HttpServletResponse response, HttpServletRequest request, Throwable exception) {
        Object handlerObject = request.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE);
        Set<Timed> annotations = this.getTimedAnnotations(handlerObject);
        Timer.Sample timerSample = timingContext.getTimerSample();
        Supplier<Iterable<Tag>> tags = () -> this.tagsProvider.getTags(request, response, handlerObject, exception);
        if (annotations.isEmpty()) {
            if (this.autoTimeRequests) {
                this.stop(timerSample, tags, Timer.builder((String)this.metricName));
            }
        } else {
            for (Timed annotation : annotations) {
                this.stop(timerSample, tags, Timer.builder((Timed)annotation, (String)this.metricName));
            }
        }
    }

    private void stop(Timer.Sample timerSample, Supplier<Iterable<Tag>> tags, Timer.Builder builder) {
        timerSample.stop(builder.tags(tags.get()).register(this.registry));
    }

    private static class TimingContext {
        private static final String ATTRIBUTE = TimingContext.class.getName();
        private final Timer.Sample timerSample;

        TimingContext(Timer.Sample timerSample) {
            this.timerSample = timerSample;
        }

        public Timer.Sample getTimerSample() {
            return this.timerSample;
        }

        public void attachTo(HttpServletRequest request) {
            request.setAttribute(ATTRIBUTE, (Object)this);
        }

        public static TimingContext get(HttpServletRequest request) {
            return (TimingContext)request.getAttribute(ATTRIBUTE);
        }
    }
}

