/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.driver;

import java.util.function.Consumer;
import okhttp3.OkHttpClient;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.util.E;

public class HugeClientBuilder {
    private static final int CPUS = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_TIMEOUT = 20;
    private static final int DEFAULT_MAX_CONNS = 4 * CPUS;
    private static final int DEFAULT_MAX_CONNS_PER_ROUTE = 2 * CPUS;
    private static final int DEFAULT_IDLE_TIME = 30;
    private static final int SECOND = 1000;
    private String url;
    private String graph;
    private String username;
    private String password;
    private int timeout;
    private int maxConns;
    private int maxConnsPerRoute;
    private int idleTime;
    private String trustStoreFile;
    private String trustStorePassword;
    private Consumer<OkHttpClient.Builder> httpBuilderConsumer;
    private Integer connectTimeout;
    private Integer readTimeout;

    public HugeClientBuilder(String url, String graph) {
        E.checkArgument((url != null && !url.isEmpty() ? 1 : 0) != 0, (String)"Expect a string value as the url parameter argument, but got: %s", (Object[])new Object[]{url});
        E.checkArgument((graph != null && !graph.isEmpty() ? 1 : 0) != 0, (String)"Expect a string value as the graph name parameter argument, but got: %s", (Object[])new Object[]{graph});
        this.url = url;
        this.graph = graph;
        this.username = "";
        this.password = "";
        this.timeout = 20000;
        this.maxConns = DEFAULT_MAX_CONNS;
        this.maxConnsPerRoute = DEFAULT_MAX_CONNS_PER_ROUTE;
        this.trustStoreFile = "";
        this.trustStorePassword = "";
        this.idleTime = 30;
        this.httpBuilderConsumer = null;
        this.connectTimeout = null;
        this.readTimeout = null;
    }

    public HugeClient build() {
        E.checkArgument((this.url != null ? 1 : 0) != 0, (String)"The url parameter can't be null", (Object[])new Object[0]);
        E.checkArgument((this.graph != null ? 1 : 0) != 0, (String)"The graph parameter can't be null", (Object[])new Object[0]);
        return new HugeClient(this);
    }

    public HugeClientBuilder configGraph(String graph) {
        this.graph = graph;
        return this;
    }

    public HugeClientBuilder configIdleTime(int idleTime) {
        E.checkArgument((idleTime > 0 ? 1 : 0) != 0, (String)"The idleTime parameter must be > 0, but got %s", (Object[])new Object[]{idleTime});
        this.idleTime = idleTime;
        return this;
    }

    public HugeClientBuilder configPool(int maxConns, int maxConnsPerRoute) {
        if (maxConns == 0) {
            maxConns = DEFAULT_MAX_CONNS;
        }
        if (maxConnsPerRoute == 0) {
            maxConnsPerRoute = DEFAULT_MAX_CONNS_PER_ROUTE;
        }
        this.maxConns = maxConns;
        this.maxConnsPerRoute = maxConnsPerRoute;
        return this;
    }

    public HugeClientBuilder configSSL(String trustStoreFile, String trustStorePassword) {
        this.trustStoreFile = trustStoreFile;
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public HugeClientBuilder configTimeout(int timeout) {
        if (timeout == 0) {
            timeout = 20;
        }
        this.timeout = timeout * 1000;
        return this;
    }

    public HugeClientBuilder configConnectTimeout(Integer connectTimeout) {
        if (connectTimeout != null) {
            this.connectTimeout = connectTimeout * 1000;
        }
        return this;
    }

    public HugeClientBuilder configReadTimeout(Integer readTimeout) {
        if (readTimeout != null) {
            this.readTimeout = readTimeout * 1000;
        }
        return this;
    }

    public HugeClientBuilder configUrl(String url) {
        this.url = url;
        return this;
    }

    public HugeClientBuilder configUser(String username, String password) {
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        this.username = username;
        this.password = password;
        return this;
    }

    public HugeClientBuilder configHttpBuilder(Consumer<OkHttpClient.Builder> builderConsumer) {
        this.httpBuilderConsumer = builderConsumer;
        return this;
    }

    public String url() {
        return this.url;
    }

    public String graph() {
        return this.graph;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public int timeout() {
        return this.timeout;
    }

    public Integer connectTimeout() {
        return this.connectTimeout;
    }

    public Integer readTimeout() {
        return this.readTimeout;
    }

    public int maxConns() {
        return this.maxConns;
    }

    public int maxConnsPerRoute() {
        return this.maxConnsPerRoute;
    }

    public int idleTime() {
        return this.idleTime;
    }

    public String trustStoreFile() {
        return this.trustStoreFile;
    }

    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    public Consumer<OkHttpClient.Builder> httpBuilderConsumer() {
        return this.httpBuilderConsumer;
    }
}

