/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.signature;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.optimizer.signature.Signature;

public final class SignatureUtils {
    private static Map<Class<?>, SignatureMapper> mappers = new HashMap();

    public static void write(Map<String, Object> ret, Object o) {
        SignatureMapper mapper = SignatureUtils.getSigMapper(o.getClass());
        mapper.write(ret, o);
    }

    private SignatureUtils() {
    }

    private static SignatureMapper getSigMapper(Class<?> o) {
        SignatureMapper m = mappers.get(o);
        if (m == null) {
            m = new SignatureMapper(o);
            mappers.put(o, m);
        }
        return m;
    }

    static class SignatureMapper {
        private List<Method> sigMethods;
        private String classLabel;

        SignatureMapper(Class<?> o) {
            Method[] f = o.getMethods();
            this.sigMethods = new ArrayList<Method>();
            for (Method method : f) {
                if (!method.isAnnotationPresent(Signature.class)) continue;
                this.sigMethods.add(method);
            }
            this.classLabel = o.getName();
        }

        public void write(Map<String, Object> ret, Object o) {
            if (this.sigMethods.isEmpty()) {
                ret.put(this.classLabel, System.identityHashCode(o));
            } else {
                ret.put(this.classLabel, "1");
                for (Method method : this.sigMethods) {
                    try {
                        Object res = method.invoke(o, new Object[0]);
                        ret.put(method.getName(), res);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error invoking signature method", e);
                    }
                }
            }
        }
    }
}

