/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Retention(value=RetentionPolicy.RUNTIME)
public @interface Explain {
    public String displayName() default "";

    public Level[] explainLevels() default {Level.DEFAULT, Level.EXTENDED};

    public boolean displayOnlyOnTrue() default false;

    public boolean skipHeader() default false;

    public boolean jsonOnly() default false;

    public Vectorization vectorization() default Vectorization.NON_VECTORIZED;

    public boolean postProcess() default false;

    public static enum Vectorization {
        SUMMARY_PATH(4),
        OPERATOR_PATH(3),
        SUMMARY(4),
        OPERATOR(3),
        EXPRESSION(2),
        DETAIL(1),
        NON_VECTORIZED(Integer.MAX_VALUE);

        public final int rank;

        private Vectorization(int rank) {
            this.rank = rank;
        }
    }

    public static enum Level {
        USER,
        DEFAULT,
        EXTENDED;


        public boolean in(Level[] levels) {
            for (Level level : levels) {
                if (!level.equals((Object)this)) continue;
                return true;
            }
            return false;
        }
    }
}

