/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.wm;

import java.text.DecimalFormat;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.management.MXBean;
import org.apache.hadoop.hive.ql.exec.tez.WmEvent;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.Constants;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.PrintSummary;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.TimeCounterLimit;
import org.apache.hadoop.hive.ql.wm.Trigger;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MXBean
public class WmContext
implements PrintSummary {
    private static final Logger LOG = LoggerFactory.getLogger(WmContext.class);
    @JsonProperty(value="queryId")
    private String queryId;
    @JsonProperty(value="queryStartTime")
    private long queryStartTime;
    @JsonProperty(value="queryEndTime")
    private long queryEndTime;
    @JsonProperty(value="queryCompleted")
    private boolean queryCompleted;
    @JsonProperty(value="queryWmEvents")
    private final List<WmEvent> queryWmEvents = new LinkedList<WmEvent>();
    @JsonProperty(value="appliedTriggers")
    private Set<Trigger> appliedTriggers = new HashSet<Trigger>();
    @JsonProperty(value="subscribedCounters")
    private Set<String> subscribedCounters = new HashSet<String>();
    @JsonProperty(value="currentCounters")
    private Map<String, Long> currentCounters = new HashMap<String, Long>();
    @JsonIgnore
    private Future<Boolean> returnEventFuture;
    private static final String WM_EVENTS_HEADER_FORMAT = "%7s %24s %24s %11s %9s %13s";
    private static final String WM_EVENTS_TITLE = "Workload Manager Events Summary";
    private static final String WM_EVENTS_TABLE_HEADER = String.format("%7s %24s %24s %11s %9s %13s", "EVENT", "START_TIMESTAMP", "END_TIMESTAMP", "ELAPSED_MS", "CLUSTER %", "POOL");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#0.00");

    public WmContext(long queryStartTime, String queryId) {
        this.queryStartTime = queryStartTime;
        this.queryId = queryId;
        this.queryCompleted = false;
    }

    public Set<Trigger> getAppliedTriggers() {
        return this.appliedTriggers;
    }

    public void addTriggers(List<Trigger> triggers) {
        if (triggers != null) {
            this.appliedTriggers.addAll(triggers);
            HashSet<String> counters = new HashSet<String>();
            for (Trigger trigger : triggers) {
                counters.add(trigger.getExpression().getCounterLimit().getName());
            }
            this.addSubscribedCounters(counters);
        }
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public Set<String> getSubscribedCounters() {
        return this.subscribedCounters;
    }

    public void setSubscribedCounters(Set<String> subscribedCounters) {
        this.subscribedCounters = subscribedCounters;
    }

    public void addSubscribedCounters(Set<String> moreCounters) {
        if (this.subscribedCounters == null) {
            this.subscribedCounters = new HashSet<String>();
        }
        this.subscribedCounters.addAll(moreCounters);
    }

    public Map<String, Long> getCurrentCounters() {
        return this.currentCounters;
    }

    public void setCurrentCounters(Map<String, Long> currentCounters) {
        this.currentCounters = currentCounters;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.queryStartTime;
    }

    public boolean isQueryCompleted() {
        return this.queryCompleted;
    }

    public void setQueryCompleted(boolean queryCompleted) {
        this.queryCompleted = queryCompleted;
        this.queryEndTime = System.currentTimeMillis();
    }

    public void addWMEvent(WmEvent wmEvent) {
        this.queryWmEvents.add(wmEvent);
    }

    public long getQueryStartTime() {
        return this.queryStartTime;
    }

    public long getQueryEndTime() {
        return this.queryEndTime;
    }

    List<WmEvent> getQueryWmEvents() {
        return this.queryWmEvents;
    }

    Future<Boolean> getReturnEventFuture() {
        return this.returnEventFuture;
    }

    public void setReturnEventFuture(Future<Boolean> returnEventFuture) {
        this.returnEventFuture = returnEventFuture;
    }

    @Override
    public void print(SessionState.LogHelper console) {
        try {
            this.waitForReturnSessionEvent();
            boolean first = false;
            console.printInfo("");
            console.printInfo(WM_EVENTS_TITLE);
            for (WmEvent wmEvent : this.queryWmEvents) {
                if (!first) {
                    console.printInfo("");
                    console.printInfo("QueryId: " + this.queryId);
                    console.printInfo("SessionId: " + this.queryWmEvents.get(0).getWmTezSessionInfo().getSessionId());
                    console.printInfo("Applied Triggers: " + this.getAppliedTriggers());
                    console.printInfo(Constants.SEPARATOR);
                    console.printInfo(WM_EVENTS_TABLE_HEADER);
                    console.printInfo(Constants.SEPARATOR);
                    first = true;
                }
                WmEvent.WmTezSessionInfo wmTezSessionInfo = wmEvent.getWmTezSessionInfo();
                String row = String.format(WM_EVENTS_HEADER_FORMAT, new Object[]{wmEvent.getEventType(), Instant.ofEpochMilli(wmEvent.getEventStartTimestamp()).toString(), Instant.ofEpochMilli(wmEvent.getEventEndTimestamp()).toString(), wmEvent.getElapsedTime(), DECIMAL_FORMAT.format(wmTezSessionInfo.getClusterPercent()), wmTezSessionInfo.getPoolName()});
                console.printInfo(row);
            }
            console.printInfo(Constants.SEPARATOR);
            console.printInfo("");
        }
        catch (Exception e) {
            LOG.warn("Unable to print WM events summary", (Throwable)e);
        }
    }

    public void printJson(SessionState.LogHelper console) {
        try {
            this.waitForReturnSessionEvent();
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.setVisibilityChecker((VisibilityChecker<?>)objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withSetterVisibility(JsonAutoDetect.Visibility.NONE));
            String wmContextJson = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
            console.printInfo("");
            console.printInfo(WM_EVENTS_TITLE);
            console.printInfo(Constants.SEPARATOR);
            console.printInfo(wmContextJson);
            console.printInfo(Constants.SEPARATOR);
            console.printInfo("");
        }
        catch (Exception e) {
            LOG.warn("Unable to serialize WMContext to json.", (Throwable)e);
        }
    }

    private void waitForReturnSessionEvent() throws ExecutionException, InterruptedException {
        if (this.getReturnEventFuture() != null && !Thread.currentThread().isInterrupted()) {
            this.getReturnEventFuture().get();
        }
    }

    public void shortPrint(SessionState.LogHelper console) throws ExecutionException, InterruptedException {
        this.waitForReturnSessionEvent();
        console.printInfo(WM_EVENTS_TITLE, false);
        for (WmEvent wmEvent : this.getQueryWmEvents()) {
            console.printInfo("Event: " + (Object)((Object)wmEvent.getEventType()) + " Pool: " + wmEvent.getWmTezSessionInfo().getPoolName() + " Cluster %: " + DECIMAL_FORMAT.format(wmEvent.getWmTezSessionInfo().getClusterPercent()));
        }
    }

    public void updateElapsedTimeCounter() {
        if (this.subscribedCounters.contains(TimeCounterLimit.TimeCounter.ELAPSED_TIME.name())) {
            this.currentCounters.put(TimeCounterLimit.TimeCounter.ELAPSED_TIME.name(), this.getElapsedTime());
        }
    }
}

