/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.hugegraph.loader.source.AbstractSource;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.loader.source.file.ListFormat;
import org.apache.hugegraph.loader.source.kafka.KafkaSource;
import org.apache.hugegraph.loader.util.DateUtil;
import org.apache.hugegraph.structure.constant.Cardinality;
import org.apache.hugegraph.structure.constant.DataType;
import org.apache.hugegraph.structure.schema.PropertyKey;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.ReflectionUtil;

public final class DataTypeUtil {
    private static final Set<String> ACCEPTABLE_TRUE = ImmutableSet.of((Object)"true", (Object)"1", (Object)"yes", (Object)"y");
    private static final Set<String> ACCEPTABLE_FALSE = ImmutableSet.of((Object)"false", (Object)"0", (Object)"no", (Object)"n");

    public static boolean isSimpleValue(Object value) {
        if (value == null) {
            return false;
        }
        return ReflectionUtil.isSimpleType(value.getClass());
    }

    public static Object convert(Object value, PropertyKey propertyKey, InputSource source) {
        E.checkArgumentNotNull((Object)value, (String)"The value to be converted can't be null", (Object[])new Object[0]);
        String key = propertyKey.name();
        DataType dataType = propertyKey.dataType();
        Cardinality cardinality = propertyKey.cardinality();
        switch (cardinality) {
            case SINGLE: {
                return DataTypeUtil.parseSingleValue(key, value, dataType, source);
            }
            case SET: 
            case LIST: {
                return DataTypeUtil.parseMultiValues(key, value, dataType, cardinality, source);
            }
        }
        throw new AssertionError((Object)String.format("Unsupported cardinality: '%s'", cardinality));
    }

    public static List<Object> splitField(String key, Object rawColumnValue, InputSource source) {
        E.checkArgument((rawColumnValue != null ? 1 : 0) != 0, (String)"The value to be split can't be null", (Object[])new Object[0]);
        if (rawColumnValue instanceof Collection) {
            return (List)rawColumnValue;
        }
        String rawValue = rawColumnValue.toString();
        return DataTypeUtil.split(key, rawValue, source);
    }

    public static long parseNumber(String key, Object rawValue) {
        if (rawValue instanceof Number) {
            return ((Number)rawValue).longValue();
        }
        if (rawValue instanceof String) {
            return DataTypeUtil.parseLong(((String)rawValue).trim());
        }
        throw new IllegalArgumentException(String.format("The value(key='%s') must can be casted to Long, but got '%s'(%s)", key, rawValue, rawValue.getClass().getName()));
    }

    public static UUID parseUUID(String key, Object rawValue) {
        if (rawValue instanceof UUID) {
            return (UUID)rawValue;
        }
        if (rawValue instanceof String) {
            String value = ((String)rawValue).trim();
            if (value.contains("-")) {
                return UUID.fromString(value);
            }
            E.checkArgument((value.length() == 32 ? 1 : 0) != 0, (String)"Invalid UUID value(key='%s') '%s'", (Object[])new Object[]{key, value});
            String high = value.substring(0, 16);
            String low = value.substring(16);
            return new UUID(Long.parseUnsignedLong(high, 16), Long.parseUnsignedLong(low, 16));
        }
        throw new IllegalArgumentException(String.format("Failed to convert value(key='%s') '%s'(%s) to UUID", key, rawValue, rawValue.getClass()));
    }

    private static Object parseSingleValue(String key, Object rawValue, DataType dataType, InputSource source) {
        Object value = rawValue;
        if (rawValue instanceof String) {
            value = ((String)rawValue).trim();
        }
        if (dataType.isNumber()) {
            return DataTypeUtil.parseNumber(key, value, dataType);
        }
        if (dataType.isBoolean()) {
            return DataTypeUtil.parseBoolean(key, value);
        }
        if (dataType.isDate()) {
            E.checkState((boolean)(source instanceof FileSource), (String)"Only accept FileSource when convert String value to Date, but got '%s'", (Object[])new Object[]{source.getClass().getName()});
            String dateFormat = ((FileSource)source).dateFormat();
            String timeZone = ((FileSource)source).timeZone();
            if (source instanceof KafkaSource) {
                List<String> extraDateFormats = ((KafkaSource)source).getExtraDateFormats();
                dateFormat = ((KafkaSource)source).getDateFormat();
                timeZone = ((KafkaSource)source).getTimeZone();
                if (extraDateFormats == null || extraDateFormats.isEmpty()) {
                    return DataTypeUtil.parseDate(key, value, dateFormat, timeZone);
                }
                HashSet<String> allDateFormats = new HashSet<String>();
                allDateFormats.add(dateFormat);
                allDateFormats.addAll(extraDateFormats);
                int size = allDateFormats.size();
                for (String df : allDateFormats) {
                    try {
                        return DataTypeUtil.parseDate(key, value, df, timeZone);
                    }
                    catch (Exception e) {
                        if (--size > 0) continue;
                        throw e;
                    }
                }
            }
            return DataTypeUtil.parseDate(key, value, dateFormat, timeZone);
        }
        if (dataType.isUUID()) {
            return DataTypeUtil.parseUUID(key, value);
        }
        if (dataType.isText() && !(rawValue instanceof String)) {
            value = rawValue.toString();
        }
        E.checkArgument((boolean)DataTypeUtil.checkDataType(key, value, dataType), (String)"The value(key='%s') '%s'(%s) is not match with data type %s and can't convert to it", (Object[])new Object[]{key, value, value.getClass(), dataType});
        return value;
    }

    private static Object parseMultiValues(String key, Object values, DataType dataType, Cardinality cardinality, InputSource source) {
        if (values instanceof Collection && DataTypeUtil.checkCollectionDataType(key, (Collection)values, dataType)) {
            return values;
        }
        E.checkState((boolean)(values instanceof String), (String)"The value(key='%s') must be String type, but got '%s'(%s)", (Object[])new Object[]{key, values});
        String rawValue = (String)values;
        List<Object> valueColl = DataTypeUtil.split(key, rawValue, source);
        Collection results = cardinality == Cardinality.LIST ? InsertionOrderUtil.newList() : InsertionOrderUtil.newSet();
        valueColl.forEach(value -> results.add(DataTypeUtil.parseSingleValue(key, value, dataType, source)));
        E.checkArgument((boolean)DataTypeUtil.checkCollectionDataType(key, results, dataType), (String)"Not all collection elems %s match with data type %s", (Object[])new Object[]{results, dataType});
        return results;
    }

    private static Boolean parseBoolean(String key, Object rawValue) {
        if (rawValue instanceof Boolean) {
            return (Boolean)rawValue;
        }
        if (rawValue instanceof String) {
            String value = ((String)rawValue).toLowerCase();
            if (ACCEPTABLE_TRUE.contains(value)) {
                return true;
            }
            if (ACCEPTABLE_FALSE.contains(value)) {
                return false;
            }
            throw new IllegalArgumentException(String.format("Failed to convert '%s'(key='%s') to Boolean, the acceptable boolean strings are %s or %s", key, rawValue, ACCEPTABLE_TRUE, ACCEPTABLE_FALSE));
        }
        throw new IllegalArgumentException(String.format("Failed to convert value(key='%s') '%s'(%s) to Boolean", key, rawValue, rawValue.getClass()));
    }

    private static Number parseNumber(String key, Object value, DataType dataType) {
        E.checkState((boolean)dataType.isNumber(), (String)"The target data type must be number", (Object[])new Object[0]);
        if (dataType.clazz().isInstance(value)) {
            return (Number)value;
        }
        try {
            switch (dataType) {
                case BYTE: {
                    return Byte.valueOf(value.toString());
                }
                case INT: {
                    return Integer.valueOf(value.toString());
                }
                case LONG: {
                    return DataTypeUtil.parseLong(value.toString());
                }
                case FLOAT: {
                    return Float.valueOf(value.toString());
                }
                case DOUBLE: {
                    return Double.valueOf(value.toString());
                }
            }
            throw new AssertionError((Object)String.format("Number type only contains Byte, Integer, Long, Float, Double, but got %s", dataType.clazz()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Failed to convert value(key=%s) '%s'(%s) to Number", key, value, value.getClass()), e);
        }
    }

    private static long parseLong(String rawValue) {
        if (rawValue.startsWith("-")) {
            return Long.parseLong(rawValue);
        }
        return Long.parseUnsignedLong(rawValue);
    }

    private static Date parseDate(String key, Object value, String dateFormat, String timeZone) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof String) {
            if ("timestamp".equals(dateFormat)) {
                try {
                    long timestamp = Long.parseLong((String)value);
                    return new Date(timestamp);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Invalid timestamp value '%s'", value));
                }
            }
            return DateUtil.parse((String)value, dateFormat, timeZone);
        }
        throw new IllegalArgumentException(String.format("Failed to convert value(key='%s') '%s'(%s) to Date", key, value, value.getClass()));
    }

    private static List<Object> split(String key, String rawValue, InputSource source) {
        ArrayList<Object> valueColl = new ArrayList<Object>();
        if (rawValue.isEmpty()) {
            return valueColl;
        }
        E.checkState((boolean)AbstractSource.class.isAssignableFrom(source.getClass()), (String)"Only accept AbstractSource when parse multi values, but got '%s'", (Object[])new Object[]{source.getClass().getName()});
        ListFormat listFormat = ((AbstractSource)source).listFormat();
        E.checkArgumentNotNull((Object)listFormat, (String)"The list_format must be set when parse list or set values", (Object[])new Object[0]);
        String startSymbol = listFormat.startSymbol();
        String endSymbol = listFormat.endSymbol();
        E.checkArgument((rawValue.length() >= startSymbol.length() + endSymbol.length() ? 1 : 0) != 0, (String)"The value(key='%s') '%s' length(%s) must be >= start symbol '%s' + end symbol '%s' length", (Object[])new Object[]{key, rawValue, rawValue.length(), startSymbol, endSymbol});
        E.checkArgument((rawValue.startsWith(startSymbol) && rawValue.endsWith(endSymbol) ? 1 : 0) != 0, (String)"The value(key='%s') must start with '%s' and end with '%s', but got '%s'", (Object[])new Object[]{key, startSymbol, endSymbol, rawValue});
        rawValue = rawValue.substring(startSymbol.length(), rawValue.length() - endSymbol.length());
        String elemDelimiter = listFormat.elemDelimiter();
        Splitter.on((String)elemDelimiter).split((CharSequence)rawValue).forEach(value -> {
            if (!listFormat.ignoredElems().contains(value)) {
                valueColl.add(value);
            }
        });
        return valueColl;
    }

    private static boolean checkDataType(String key, Object value, DataType dataType) {
        if (value instanceof Number && dataType.isNumber()) {
            return DataTypeUtil.parseNumber(key, value, dataType) != null;
        }
        return dataType.clazz().isInstance(value);
    }

    private static boolean checkCollectionDataType(String key, Collection<?> values, DataType dataType) {
        for (Object value : values) {
            if (DataTypeUtil.checkDataType(key, value, dataType)) continue;
            return false;
        }
        return true;
    }
}

