/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.driver;

import org.apache.hugegraph.api.job.RebuildAPI;
import org.apache.hugegraph.api.task.TaskAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.structure.schema.EdgeLabel;
import org.apache.hugegraph.structure.schema.IndexLabel;
import org.apache.hugegraph.structure.schema.VertexLabel;

public class JobManager {
    private RebuildAPI rebuildAPI;
    private TaskAPI taskAPI;

    public JobManager(RestClient client, String graph) {
        this.rebuildAPI = new RebuildAPI(client, graph);
        this.taskAPI = new TaskAPI(client, graph);
    }

    public void rebuild(VertexLabel vertexLabel) {
        this.rebuild(vertexLabel, 60L);
    }

    public void rebuild(VertexLabel vertexLabel, long seconds) {
        long task = this.rebuildAPI.rebuild(vertexLabel);
        this.taskAPI.waitUntilTaskSuccess(task, seconds);
    }

    public long rebuildAsync(VertexLabel vertexLabel) {
        return this.rebuildAPI.rebuild(vertexLabel);
    }

    public void rebuild(EdgeLabel edgeLabel) {
        this.rebuild(edgeLabel, 60L);
    }

    public void rebuild(EdgeLabel edgeLabel, long seconds) {
        long task = this.rebuildAPI.rebuild(edgeLabel);
        this.taskAPI.waitUntilTaskSuccess(task, seconds);
    }

    public long rebuildAsync(EdgeLabel edgeLabel) {
        return this.rebuildAPI.rebuild(edgeLabel);
    }

    public void rebuild(IndexLabel indexLabel) {
        this.rebuild(indexLabel, 60L);
    }

    public void rebuild(IndexLabel indexLabel, long seconds) {
        long task = this.rebuildAPI.rebuild(indexLabel);
        this.taskAPI.waitUntilTaskSuccess(task, seconds);
    }

    public long rebuildAsync(IndexLabel indexLabel) {
        return this.rebuildAPI.rebuild(indexLabel);
    }
}

