/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class StoppableThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(StoppableThread.class);

    public StoppableThread(ThreadGroup group, String name) {
        super(group, name);
    }

    public abstract void sendStopSignal();

    public void awaitTermination() {
        try {
            long startTime = EnvironmentEdgeManager.currentTime();
            int i = 0;
            while (this.isAlive()) {
                this.sendStopSignal();
                this.join(250L);
                if (i > 0 && i % 8 == 0) {
                    LOG.warn("Waiting termination of thread {}, {}; sending interrupt", (Object)this.getName(), (Object)StringUtils.humanTimeDiff(EnvironmentEdgeManager.currentTime() - startTime));
                    this.interrupt();
                }
                ++i;
            }
        }
        catch (InterruptedException e) {
            LOG.warn("{} join wait got interrupted", (Object)this.getName(), (Object)e);
        }
    }
}

