/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.exception;

public class ExitException
extends RuntimeException {
    private final String details;
    private final Integer exitCode;

    public ExitException(String details, String reason) {
        super(reason);
        this.details = details;
        this.exitCode = 0;
    }

    public ExitException(String details, String reason, Object ... args) {
        super(String.format(reason, args));
        this.details = details;
        this.exitCode = 0;
    }

    public ExitException(Integer exitCode, String details, String reason) {
        super(reason);
        this.details = details;
        this.exitCode = exitCode;
    }

    public ExitException(Integer exitCode, String details, String reason, Throwable cause) {
        super(reason, cause);
        this.details = details;
        this.exitCode = exitCode;
    }

    public ExitException(Integer exitCode, String details, String reason, Object ... args) {
        super(String.format(reason, args));
        this.details = details;
        this.exitCode = exitCode;
    }

    public ExitException(Integer exitCode, String details, String reason, Throwable cause, Object ... args) {
        super(String.format(reason, args), cause);
        this.details = details;
        this.exitCode = exitCode;
    }

    public String details() {
        return this.details;
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public static ExitException exception(String details, String reason, Object ... args) {
        return new ExitException((Integer)-1, details, reason, args);
    }

    public static ExitException normal(String details, String reason, Object ... args) {
        return new ExitException((Integer)0, details, reason, args);
    }
}

