/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.formatter;

import org.apache.hugegraph.structure.JsonGraph;

public interface Formatter {
    public static final String PACKAGE = Formatter.class.getPackage().getName();

    public String dump(JsonGraph.JsonVertex var1) throws Exception;

    public static Formatter loadFormatter(String formatter) {
        String classPath = String.format("%s.%s", PACKAGE, formatter);
        ClassLoader loader = Formatter.class.getClassLoader();
        try {
            Class<?> clazz = loader.loadClass(classPath);
            if (!Formatter.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("Invalid formatter: " + formatter);
            }
            return (Formatter)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't load formatter: " + formatter, e);
        }
    }
}

