/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CopyOnFirstWriteProperties
extends Properties {
    private Properties interned;
    private static Interner<Properties> INTERNER = Interners.newWeakInterner();
    private static Field defaultsField;

    public CopyOnFirstWriteProperties(Properties p) {
        this.setInterned(p);
    }

    @Override
    public String getProperty(String key) {
        if (this.interned != null) {
            return this.interned.getProperty(key);
        }
        return super.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (this.interned != null) {
            return this.interned.getProperty(key, defaultValue);
        }
        return super.getProperty(key, defaultValue);
    }

    @Override
    public void list(PrintStream out) {
        if (this.interned != null) {
            this.interned.list(out);
        } else {
            super.list(out);
        }
    }

    @Override
    public void list(PrintWriter out) {
        if (this.interned != null) {
            this.interned.list(out);
        } else {
            super.list(out);
        }
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        super.load(inStream);
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        super.load(reader);
    }

    @Override
    public synchronized void loadFromXML(InputStream inStream) throws IOException {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        super.loadFromXML(inStream);
    }

    @Override
    public Enumeration<?> propertyNames() {
        if (this.interned != null) {
            return this.interned.propertyNames();
        }
        return super.propertyNames();
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        return super.setProperty(key, value);
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        if (this.interned != null) {
            this.interned.store(out, comments);
        } else {
            super.store(out, comments);
        }
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        if (this.interned != null) {
            this.interned.storeToXML(os, comment);
        } else {
            super.storeToXML(os, comment);
        }
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        if (this.interned != null) {
            this.interned.storeToXML(os, comment, encoding);
        } else {
            super.storeToXML(os, comment, encoding);
        }
    }

    @Override
    public Set<String> stringPropertyNames() {
        if (this.interned != null) {
            return this.interned.stringPropertyNames();
        }
        return super.stringPropertyNames();
    }

    @Override
    public synchronized void clear() {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        super.clear();
    }

    @Override
    public synchronized Object clone() {
        if (this.interned != null) {
            return new CopyOnFirstWriteProperties(this.interned);
        }
        return super.clone();
    }

    @Override
    public synchronized Object compute(Object key, BiFunction remappingFunction) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        return super.compute(key, remappingFunction);
    }

    @Override
    public synchronized Object computeIfAbsent(Object key, Function mappingFunction) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        return super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public synchronized Object computeIfPresent(Object key, BiFunction remappingFunction) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        return super.computeIfPresent(key, remappingFunction);
    }

    @Override
    public synchronized boolean contains(Object value) {
        if (this.interned != null) {
            return this.interned.contains(value);
        }
        return super.contains(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        if (this.interned != null) {
            return this.interned.containsKey(key);
        }
        return super.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        if (this.interned != null) {
            return this.interned.containsValue(value);
        }
        return super.containsValue(value);
    }

    @Override
    public synchronized Enumeration<Object> elements() {
        if (this.interned != null) {
            return this.interned.elements();
        }
        return super.elements();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        if (this.interned != null) {
            return this.interned.entrySet();
        }
        return super.entrySet();
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this.interned != null) {
            return this.interned.equals(o);
        }
        return super.equals(o);
    }

    @Override
    public synchronized void forEach(BiConsumer action) {
        if (this.interned != null) {
            this.interned.forEach(action);
        } else {
            super.forEach(action);
        }
    }

    @Override
    public synchronized Object get(Object key) {
        if (this.interned != null) {
            return this.interned.get(key);
        }
        return super.get(key);
    }

    @Override
    public synchronized Object getOrDefault(Object key, Object defaultValue) {
        if (this.interned != null) {
            return this.interned.getOrDefault(key, defaultValue);
        }
        return super.getOrDefault(key, defaultValue);
    }

    @Override
    public synchronized int hashCode() {
        if (this.interned != null) {
            return this.interned.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.interned != null) {
            return this.interned.isEmpty();
        }
        return super.isEmpty();
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        if (this.interned != null) {
            return this.interned.keys();
        }
        return super.keys();
    }

    @Override
    public Set<Object> keySet() {
        if (this.interned != null) {
            return this.interned.keySet();
        }
        return super.keySet();
    }

    @Override
    public synchronized Object merge(Object key, Object value, BiFunction remappingFunction) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        return super.merge(key, value, remappingFunction);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        return super.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        super.putAll(t);
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        return super.remove(key);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        return super.remove(key, value);
    }

    @Override
    public synchronized Object replace(Object key, Object value) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        return super.replace(key, value);
    }

    @Override
    public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        return super.replace(key, oldValue, newValue);
    }

    @Override
    public synchronized void replaceAll(BiFunction function) {
        if (this.interned != null) {
            this.copyFromInternedToThis();
        }
        super.replaceAll(function);
    }

    @Override
    public synchronized int size() {
        if (this.interned != null) {
            return this.interned.size();
        }
        return super.size();
    }

    @Override
    public synchronized String toString() {
        if (this.interned != null) {
            return this.interned.toString();
        }
        return super.toString();
    }

    @Override
    public Collection<Object> values() {
        if (this.interned != null) {
            return this.interned.values();
        }
        return super.values();
    }

    private void copyFromInternedToThis() {
        for (Map.Entry<Object, Object> e : this.interned.entrySet()) {
            super.put(e.getKey(), e.getValue());
        }
        try {
            this.defaults = (Properties)defaultsField.get(this.interned);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.setInterned(null);
    }

    public void setInterned(Properties p) {
        this.interned = p != null ? (Properties)INTERNER.intern((Object)p) : p;
    }

    public CopyOnFirstWriteProperties() {
    }

    public Properties getInterned() {
        return this.interned;
    }

    static {
        try {
            defaultsField = Properties.class.getDeclaredField("defaults");
            defaultsField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

