/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public enum Order {
    ASCENDING{

        @Override
        public int cmp(int cmp) {
            return cmp;
        }

        @Override
        public byte apply(byte val) {
            return val;
        }

        @Override
        public void apply(byte[] val) {
        }

        @Override
        public void apply(byte[] val, int offset, int length) {
        }

        public String toString() {
            return "ASCENDING";
        }
    }
    ,
    DESCENDING{
        private static final byte MASK = -1;

        @Override
        public int cmp(int cmp) {
            return -1 * cmp;
        }

        @Override
        public byte apply(byte val) {
            return ~val;
        }

        @Override
        public void apply(byte[] val) {
            int i = 0;
            while (i < val.length) {
                int n = i++;
                val[n] = ~val[n];
            }
        }

        @Override
        public void apply(byte[] val, int offset, int length) {
            for (int i = 0; i < length; ++i) {
                int n = offset + i;
                val[n] = ~val[n];
            }
        }

        public String toString() {
            return "DESCENDING";
        }
    };


    public abstract int cmp(int var1);

    public abstract byte apply(byte var1);

    public abstract void apply(byte[] var1);

    public abstract void apply(byte[] var1, int var2, int var3);
}

