/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.configuration.SystemLocalConfiguration;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.fileio.AsyncFileIoFactory;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.fileio.RandomAccessFileIoFactory;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.pagememory.configuration.CheckpointConfiguration;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.pagememory.persistence.PartitionMetaManager;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointManager;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointMetricSource;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite.internal.storage.configurations.StorageProfileView;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite.internal.storage.pagememory.AbstractPageMemoryStorageEngine;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryDataRegion;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryStorageMetricSource;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryStorageMetrics;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.StoragePartitionMeta;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PageMemoryCheckpointConfiguration;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PageMemoryCheckpointView;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryProfileConfiguration;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryProfileView;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryStorageEngineConfiguration;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryStorageEngineExtensionConfiguration;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class PersistentPageMemoryStorageEngine
extends AbstractPageMemoryStorageEngine {
    public static final String ENGINE_NAME = "aipersist";
    public static final int MAX_DESTRUCTION_WORK_UNITS = 1000;
    public static final String THROTTLING_TYPE_SYSTEM_PROPERTY = "aipersistThrottling";
    public static final String THROTTLING_LOG_THRESHOLD_SYSTEM_PROPERTY = "aipersistThrottlingLogThresholdMillis";
    public static final String THROTTLING_MAX_DIRTY_PAGES_SYSTEM_PROPERTY = "aipersistThrottlingMaxDirtyPages";
    public static final String THROTTLING_MIN_DIRTY_PAGES_SYSTEM_PROPERTY = "aipersistThrottlingMinDirtyPages";
    private static final IgniteLogger LOG = Loggers.forClass(PersistentPageMemoryStorageEngine.class);
    private final String igniteInstanceName;
    private final MetricManager metricManager;
    private final PersistentPageMemoryStorageEngineConfiguration engineConfig;
    private final StorageConfiguration storageConfig;
    @Nullable
    private final SystemLocalConfiguration systemLocalConfig;
    private final PageIoRegistry ioRegistry;
    private final Path storagePath;
    @Nullable
    private final LongJvmPauseDetector longJvmPauseDetector;
    private final Map<String, PersistentPageMemoryDataRegion> regions = new ConcurrentHashMap<String, PersistentPageMemoryDataRegion>();
    @Nullable
    private volatile FilePageStoreManager filePageStoreManager;
    @Nullable
    private volatile PartitionMetaManager partitionMetaManager;
    @Nullable
    private volatile CheckpointManager checkpointManager;
    private volatile ExecutorService destructionExecutor;
    private final FailureManager failureManager;
    private final LogSyncer logSyncer;
    private final ExecutorService commonExecutorService;

    public PersistentPageMemoryStorageEngine(String igniteInstanceName, MetricManager metricManager, StorageConfiguration storageConfig, @Nullable SystemLocalConfiguration systemLocalConfig, PageIoRegistry ioRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector, FailureManager failureManager, LogSyncer logSyncer, ExecutorService commonExecutorService, HybridClock clock) {
        super(clock);
        this.igniteInstanceName = igniteInstanceName;
        this.metricManager = metricManager;
        this.storageConfig = storageConfig;
        this.engineConfig = ((PersistentPageMemoryStorageEngineExtensionConfiguration)storageConfig.engines()).aipersist();
        this.systemLocalConfig = systemLocalConfig;
        this.ioRegistry = ioRegistry;
        this.storagePath = storagePath;
        this.longJvmPauseDetector = longJvmPauseDetector;
        this.failureManager = failureManager;
        this.logSyncer = logSyncer;
        this.commonExecutorService = commonExecutorService;
    }

    public PersistentPageMemoryStorageEngineConfiguration configuration() {
        return this.engineConfig;
    }

    public String name() {
        return ENGINE_NAME;
    }

    public void start() throws StorageException {
        int pageSize = (Integer)this.engineConfig.pageSizeBytes().value();
        try {
            AsyncFileIoFactory fileIoFactory = (Boolean)this.engineConfig.checkpoint().useAsyncFileIoFactory().value() != false ? new AsyncFileIoFactory() : new RandomAccessFileIoFactory();
            this.filePageStoreManager = this.createFilePageStoreManager(this.igniteInstanceName, this.storagePath, (FileIoFactory)fileIoFactory, pageSize, this.failureManager);
            this.filePageStoreManager.start();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error starting file page store manager", (Throwable)e);
        }
        this.partitionMetaManager = new PartitionMetaManager(this.ioRegistry, pageSize, StoragePartitionMeta.FACTORY);
        CheckpointMetricSource checkpointMetricSource = new CheckpointMetricSource("storage.aipersist.checkpoint");
        try {
            this.checkpointManager = new CheckpointManager(this.igniteInstanceName, this.longJvmPauseDetector, this.failureManager, PersistentPageMemoryStorageEngine.checkpointConfiguration(this.engineConfig.checkpoint()), this.filePageStoreManager, this.partitionMetaManager, this.regions.values(), this.ioRegistry, this.logSyncer, this.commonExecutorService, checkpointMetricSource, pageSize);
            this.checkpointManager.start();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error starting checkpoint manager", (Throwable)e);
        }
        for (StorageProfileView storageProfileView : (NamedListView)this.storageConfig.profiles().value()) {
            if (!(storageProfileView instanceof PersistentPageMemoryProfileView)) continue;
            String profileName = storageProfileView.name();
            PersistentPageMemoryProfileConfiguration storageProfileConfiguration = (PersistentPageMemoryProfileConfiguration)this.storageConfig.profiles().get(profileName);
            assert (storageProfileConfiguration != null) : profileName;
            this.addDataRegion(storageProfileConfiguration);
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)IgniteThreadFactory.create((String)this.igniteInstanceName, (String)"persistent-mv-partition-destruction", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
        executor.allowCoreThreadTimeOut(true);
        this.destructionExecutor = executor;
        PersistentPageMemoryStorageMetricSource storageMetricSource = new PersistentPageMemoryStorageMetricSource("storage.aipersist");
        PersistentPageMemoryStorageMetrics.initMetrics(storageMetricSource, this.filePageStoreManager);
        this.metricManager.registerSource((MetricSource)checkpointMetricSource);
        this.metricManager.registerSource((MetricSource)storageMetricSource);
        this.metricManager.enable((MetricSource)checkpointMetricSource);
        this.metricManager.enable((MetricSource)storageMetricSource);
    }

    public static CheckpointConfiguration checkpointConfiguration(PageMemoryCheckpointConfiguration checkpointCfg) {
        return CheckpointConfiguration.builder().checkpointThreads(((PageMemoryCheckpointView)checkpointCfg.value()).checkpointThreads()).compactionThreads(((PageMemoryCheckpointView)checkpointCfg.value()).compactionThreads()).intervalMillis(() -> checkpointCfg.intervalMillis().value()).intervalDeviationPercent(() -> checkpointCfg.intervalDeviationPercent().value()).readLockTimeoutMillis(() -> checkpointCfg.readLockTimeoutMillis().value()).logReadLockThresholdTimeoutMillis(() -> checkpointCfg.logReadLockThresholdTimeoutMillis().value()).build();
    }

    public void stop() throws StorageException {
        try {
            Stream<AutoCloseable> closeRegions = this.regions.values().stream().map(region -> region::stop);
            ExecutorService destructionExecutor = this.destructionExecutor;
            CheckpointManager checkpointManager = this.checkpointManager;
            FilePageStoreManager filePageStoreManager = this.filePageStoreManager;
            Stream<AutoCloseable> resources = Stream.of(destructionExecutor == null ? null : () -> IgniteUtils.shutdownAndAwaitTermination((ExecutorService)destructionExecutor, (long)30L, (TimeUnit)TimeUnit.SECONDS), checkpointManager == null ? null : () -> ((CheckpointManager)checkpointManager).stop(), filePageStoreManager == null ? null : () -> ((FilePageStoreManager)filePageStoreManager).stop());
            IgniteUtils.closeAll(Stream.concat(resources, closeRegions));
        }
        catch (Exception e) {
            throw new StorageException("Error when stopping components", (Throwable)e);
        }
    }

    public boolean isVolatile() {
        return false;
    }

    public MvTableStorage createMvTable(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier) throws StorageException {
        PersistentPageMemoryDataRegion dataRegion = this.regions.get(tableDescriptor.getStorageProfile());
        assert (dataRegion != null) : "tableId=" + tableDescriptor.getId() + ", dataRegion=" + tableDescriptor.getStorageProfile();
        PersistentPageMemoryTableStorage tableStorage = new PersistentPageMemoryTableStorage(tableDescriptor, indexDescriptorSupplier, this, dataRegion, this.destructionExecutor, (FailureProcessor)this.failureManager);
        dataRegion.addTableStorage(tableStorage);
        return tableStorage;
    }

    public void destroyMvTable(int tableId) {
        FilePageStoreManager filePageStoreManager = this.filePageStoreManager;
        assert (filePageStoreManager != null) : "Component has not started";
        try {
            filePageStoreManager.destroyGroupIfExists(tableId);
        }
        catch (IOException e) {
            throw new StorageException("Failed to destroy table directory: {}", (Throwable)e, new Object[]{tableId});
        }
    }

    @Nullable
    public CheckpointManager checkpointManager() {
        return this.checkpointManager;
    }

    protected FilePageStoreManager createFilePageStoreManager(String igniteInstanceName, Path storagePath, FileIoFactory fileIoFactory, int pageSize, FailureManager failureManager) throws IgniteInternalCheckedException {
        return new FilePageStoreManager(igniteInstanceName, storagePath, fileIoFactory, pageSize, failureManager);
    }

    private void addDataRegion(PersistentPageMemoryProfileConfiguration storageProfileConfiguration) {
        int pageSize = (Integer)this.engineConfig.pageSizeBytes().value();
        PersistentPageMemoryDataRegion dataRegion = new PersistentPageMemoryDataRegion(this.metricManager, storageProfileConfiguration, this.systemLocalConfig, this.ioRegistry, this.filePageStoreManager, this.partitionMetaManager, this.checkpointManager, pageSize);
        dataRegion.start();
        this.regions.put((String)storageProfileConfiguration.name().value(), dataRegion);
    }

    public Set<Integer> tableIdsOnDisk() {
        return Objects.requireNonNull(this.filePageStoreManager, "Not started").allGroupIdsOnFs();
    }
}

