/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.rocksdb.ColumnFamily;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.rocksdb.IgniteRocksDbException;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbStorageUtils;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractWriteBatch;
import org.rocksdb.RocksDBException;

public class RocksDbMetaStorage {
    public static final byte[] PARTITION_META_PREFIX = new byte[]{0};
    public static final byte[] PARTITION_CONF_PREFIX = new byte[]{1};
    public static final byte[] INDEX_ROW_ID_PREFIX = new byte[]{2};
    public static final byte[] LEASE_PREFIX = new byte[]{3};
    public static final byte[] ESTIMATED_SIZE_PREFIX = new byte[]{4};
    private final ColumnFamily metaColumnFamily;

    public RocksDbMetaStorage(ColumnFamily metaColumnFamily) {
        this.metaColumnFamily = metaColumnFamily;
    }

    public ColumnFamily columnFamily() {
        return this.metaColumnFamily;
    }

    @Nullable
    public RowId getNextRowIdToBuild(int tableId, int indexId, int partitionId) {
        try {
            byte[] lastBuiltRowIdBytes = this.metaColumnFamily.get(RocksDbStorageUtils.createKey(INDEX_ROW_ID_PREFIX, tableId, indexId, partitionId));
            if (lastBuiltRowIdBytes == null) {
                return null;
            }
            return new RowId(partitionId, RocksDbStorageUtils.getRowIdUuid(ByteBuffer.wrap(lastBuiltRowIdBytes), 0));
        }
        catch (RocksDBException e) {
            throw new IgniteRocksDbException(String.format("Failed to read next row ID to build: [partitionId=%d, indexId=%d]", partitionId, indexId), e);
        }
    }

    public void putNextRowIdToBuild(AbstractWriteBatch writeBatch, int tableId, int indexId, int partitionId, @Nullable RowId rowId) {
        try {
            byte[] key = RocksDbStorageUtils.createKey(INDEX_ROW_ID_PREFIX, tableId, indexId, partitionId);
            if (rowId == null) {
                writeBatch.delete(this.metaColumnFamily.handle(), key);
            } else {
                writeBatch.put(this.metaColumnFamily.handle(), key, RocksDbMetaStorage.indexLastBuildRowId(rowId));
            }
        }
        catch (RocksDBException e) {
            throw new IgniteRocksDbException(String.format("Failed to save next row ID to build: [partitionId=%d, indexId=%d]", partitionId, indexId), e);
        }
    }

    public void removeNextRowIdToBuild(AbstractWriteBatch writeBatch, int tableId, int indexId, int partitionId) {
        try {
            writeBatch.delete(this.metaColumnFamily.handle(), RocksDbStorageUtils.createKey(INDEX_ROW_ID_PREFIX, tableId, indexId, partitionId));
        }
        catch (RocksDBException e) {
            throw new IgniteRocksDbException(String.format("Failed to remove next row ID to build: [partitionId=%d, indexId=%d]", partitionId, indexId), e);
        }
    }

    private static byte[] indexLastBuildRowId(RowId rowId) {
        ByteBuffer buffer = ByteBuffer.allocate(16).order(RocksDbStorageUtils.KEY_BYTE_ORDER);
        RocksDbStorageUtils.putRowIdUuid(buffer, rowId.uuid());
        return buffer.array();
    }
}

