/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.utils;

import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubAckPayload;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import java.util.List;
import lombok.Generated;
import org.apache.bifromq.mqtt.utils.IMQTTMessageSizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTT5MessageSizer
implements IMQTTMessageSizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTT5MessageSizer.class);
    static final IMQTTMessageSizer INSTANCE = new MQTT5MessageSizer();

    @Override
    public IMQTTMessageSizer.MqttMessageSize sizeOf(MqttMessage message) {
        switch (message.fixedHeader().messageType()) {
            case CONNECT: {
                MqttConnectMessage connMsg = (MqttConnectMessage)message;
                return new MqttMessageSize(this.sizeConnVarHeader(connMsg.variableHeader()), this.sizeConnPayload(connMsg));
            }
            case CONNACK: {
                MqttConnAckMessage connMsg = (MqttConnAckMessage)message;
                return new MqttMessageSize(this.sizeConnAckVarHeader(connMsg.variableHeader()), 0);
            }
            case PUBLISH: {
                MqttPublishMessage pubMsg = (MqttPublishMessage)message;
                return new MqttMessageSize(this.sizePubVarHeader(pubMsg.variableHeader()), pubMsg.payload().readableBytes());
            }
            case PUBACK: {
                MqttPubReplyMessageVariableHeader pubReplyVarHeader;
                Object object = message.variableHeader();
                if (object instanceof MqttPubReplyMessageVariableHeader && ((pubReplyVarHeader = (MqttPubReplyMessageVariableHeader)object).reasonCode() != 0 || !pubReplyVarHeader.properties().isEmpty())) {
                    MqttVarHeaderBytes varHeaderBytes = this.sizePubReplyHeader(pubReplyVarHeader);
                    return new MqttMessageSize(varHeaderBytes, 0);
                }
                return TWO_BYTES_REMAINING_LENGTH;
            }
            case PUBREC: {
                MqttPubReplyMessageVariableHeader pubReplyVarHeader;
                Object varHeaderBytes = message.variableHeader();
                if (varHeaderBytes instanceof MqttPubReplyMessageVariableHeader && ((pubReplyVarHeader = (MqttPubReplyMessageVariableHeader)varHeaderBytes).reasonCode() != 0 || !pubReplyVarHeader.properties().isEmpty())) {
                    varHeaderBytes = this.sizePubReplyHeader(pubReplyVarHeader);
                    return new MqttMessageSize((MqttVarHeaderBytes)varHeaderBytes, 0);
                }
                return TWO_BYTES_REMAINING_LENGTH;
            }
            case PUBREL: {
                MqttPubReplyMessageVariableHeader pubReplyVarHeader;
                Object varHeaderBytes = message.variableHeader();
                if (varHeaderBytes instanceof MqttPubReplyMessageVariableHeader && ((pubReplyVarHeader = (MqttPubReplyMessageVariableHeader)varHeaderBytes).reasonCode() != 0 || !pubReplyVarHeader.properties().isEmpty())) {
                    varHeaderBytes = this.sizePubReplyHeader(pubReplyVarHeader);
                    return new MqttMessageSize((MqttVarHeaderBytes)varHeaderBytes, 0);
                }
                return TWO_BYTES_REMAINING_LENGTH;
            }
            case PUBCOMP: {
                MqttPubReplyMessageVariableHeader pubReplyVarHeader;
                Object varHeaderBytes = message.variableHeader();
                if (varHeaderBytes instanceof MqttPubReplyMessageVariableHeader && ((pubReplyVarHeader = (MqttPubReplyMessageVariableHeader)varHeaderBytes).reasonCode() != 0 || !pubReplyVarHeader.properties().isEmpty())) {
                    varHeaderBytes = this.sizePubReplyHeader(pubReplyVarHeader);
                    return new MqttMessageSize((MqttVarHeaderBytes)varHeaderBytes, 0);
                }
                return TWO_BYTES_REMAINING_LENGTH;
            }
            case SUBSCRIBE: {
                MqttSubscribeMessage subMsg = (MqttSubscribeMessage)message;
                return new MqttMessageSize(this.sizeIdAndPropsVarHeader(subMsg.idAndPropertiesVariableHeader()), this.sizeSubPayload(subMsg.payload()));
            }
            case SUBACK: {
                MqttSubAckMessage subAckMsg = (MqttSubAckMessage)message;
                return new MqttMessageSize(this.sizeIdAndPropsVarHeader(subAckMsg.idAndPropertiesVariableHeader()), this.sizeSubAckPayload(subAckMsg.payload()));
            }
            case UNSUBSCRIBE: {
                MqttUnsubscribeMessage unsubMsg = (MqttUnsubscribeMessage)message;
                return new MqttMessageSize(this.sizeIdAndPropsVarHeader(unsubMsg.idAndPropertiesVariableHeader()), this.sizeUnsubPayload(unsubMsg.payload()));
            }
            case UNSUBACK: {
                MqttUnsubAckMessage unsubAckMsg = (MqttUnsubAckMessage)message;
                return new MqttMessageSize(this.sizeIdAndPropsVarHeader(unsubAckMsg.idAndPropertiesVariableHeader()), this.sizeUnsubAckPayload(unsubAckMsg.payload()));
            }
            case DISCONNECT: {
                if (message.variableHeader() == null) {
                    return ZERO_BYTES_REMAINING_LENGTH;
                }
                MqttVarHeaderBytes varHeaderBytes = this.sizeReasonCodeAndPropertiesVarHeader((MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader());
                return new MqttMessageSize(varHeaderBytes, 0);
            }
            case PINGREQ: 
            case PINGRESP: {
                return ZERO_BYTES_REMAINING_LENGTH;
            }
            case AUTH: {
                if (message.variableHeader() == null) {
                    return ZERO_BYTES_REMAINING_LENGTH;
                }
                MqttVarHeaderBytes varHeaderBytes = this.sizeReasonCodeAndPropertiesVarHeader((MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader());
                return new MqttMessageSize(varHeaderBytes, 0);
            }
        }
        log.error("Unknown message type for sizing: {}", (Object)message.fixedHeader().messageType());
        return ZERO_BYTES_REMAINING_LENGTH;
    }

    @Override
    public int lastWillSize(MqttConnectMessage message) {
        MqttConnectPayload payload = message.payload();
        int size = 0;
        if (message.variableHeader().isWillFlag()) {
            size += IMQTTMessageSizer.sizeUTF8EncodedString(payload.willTopic());
            size += IMQTTMessageSizer.sizeBinary(payload.willMessageInBytes());
            MqttPropertiesBytes willPropBytes = this.sizeMqttProperties(payload.willProperties());
            size += willPropBytes.minBytes + willPropBytes.reasonStringBytes + willPropBytes.userPropsBytes;
        }
        return size;
    }

    private MqttVarHeaderBytes sizeConnVarHeader(MqttConnectVariableHeader header) {
        MqttPropertiesBytes propsBytes = this.sizeMqttProperties(header.properties());
        return new MqttVarHeaderBytes(10 + propsBytes.minBytes, propsBytes.reasonStringBytes, propsBytes.userPropsBytes);
    }

    private MqttVarHeaderBytes sizeConnAckVarHeader(MqttConnAckVariableHeader header) {
        MqttPropertiesBytes propsBytes = this.sizeMqttProperties(header.properties());
        return new MqttVarHeaderBytes(2 + propsBytes.minBytes, propsBytes.reasonStringBytes, propsBytes.userPropsBytes);
    }

    private MqttVarHeaderBytes sizeReasonCodeAndPropertiesVarHeader(MqttReasonCodeAndPropertiesVariableHeader header) {
        MqttPropertiesBytes mqttPropsBytes = this.sizeMqttProperties(header.properties());
        return new MqttVarHeaderBytes(1 + mqttPropsBytes.minBytes, mqttPropsBytes.reasonStringBytes, mqttPropsBytes.userPropsBytes);
    }

    private int sizeConnPayload(MqttConnectMessage message) {
        MqttConnectPayload payload = message.payload();
        int clientIdBytes = IMQTTMessageSizer.sizeUTF8EncodedString(payload.clientIdentifier());
        int usernameBytes = message.variableHeader().hasUserName() ? IMQTTMessageSizer.sizeUTF8EncodedString(payload.userName()) : 0;
        int passwordBytes = message.variableHeader().hasPassword() ? IMQTTMessageSizer.sizeBinary(payload.passwordInBytes()) : 0;
        int payloadSize = clientIdBytes + usernameBytes + passwordBytes;
        if (message.variableHeader().isWillFlag()) {
            payloadSize += IMQTTMessageSizer.sizeUTF8EncodedString(payload.willTopic());
            payloadSize += IMQTTMessageSizer.sizeBinary(payload.willMessageInBytes());
            MqttPropertiesBytes willPropBytes = this.sizeMqttProperties(payload.willProperties());
            payloadSize += willPropBytes.minBytes + willPropBytes.reasonStringBytes + willPropBytes.userPropsBytes;
        }
        return payloadSize;
    }

    private MqttVarHeaderBytes sizePubVarHeader(MqttPublishVariableHeader header) {
        int topicNameBytes = IMQTTMessageSizer.sizeUTF8EncodedString(header.topicName());
        int packetIdBytes = header.packetId() == 0 ? 0 : 2;
        MqttPropertiesBytes propBytes = this.sizeMqttProperties(header.properties());
        return new MqttVarHeaderBytes(topicNameBytes + packetIdBytes + propBytes.minBytes, propBytes.reasonStringBytes, propBytes.userPropsBytes);
    }

    private MqttVarHeaderBytes sizePubReplyHeader(MqttPubReplyMessageVariableHeader header) {
        MqttPropertiesBytes propBytes = this.sizeMqttProperties(header.properties());
        return new MqttVarHeaderBytes(3 + propBytes.minBytes, propBytes.reasonStringBytes, propBytes.userPropsBytes);
    }

    private MqttVarHeaderBytes sizeIdAndPropsVarHeader(MqttMessageIdAndPropertiesVariableHeader header) {
        MqttPropertiesBytes propsBytes = this.sizeMqttProperties(header.properties());
        return new MqttVarHeaderBytes(2 + propsBytes.minBytes, propsBytes.reasonStringBytes, propsBytes.userPropsBytes);
    }

    private int sizeSubPayload(MqttSubscribePayload payload) {
        int totalBytes = 0;
        for (MqttTopicSubscription sub : payload.topicSubscriptions()) {
            totalBytes += 1 + IMQTTMessageSizer.sizeUTF8EncodedString(sub.topicFilter());
        }
        return totalBytes;
    }

    private int sizeUnsubPayload(MqttUnsubscribePayload payload) {
        int totalBytes = 0;
        for (String topicFilter : payload.topics()) {
            totalBytes += IMQTTMessageSizer.sizeUTF8EncodedString(topicFilter);
        }
        return totalBytes;
    }

    private int sizeSubAckPayload(MqttSubAckPayload payload) {
        return payload.reasonCodes().size();
    }

    private int sizeUnsubAckPayload(MqttUnsubAckPayload payload) {
        return payload.unsubscribeReasonCodes().size();
    }

    private MqttPropertiesBytes sizeMqttProperties(MqttProperties mqttProps) {
        int minBytes = 0;
        int reasonStringBytes = 0;
        int userPropsBytes = 0;
        for (MqttProperties.MqttProperty mqttProperty : mqttProps.listAll()) {
            switch (MqttProperties.MqttPropertyType.valueOf((int)mqttProperty.propertyId())) {
                case PAYLOAD_FORMAT_INDICATOR: {
                    minBytes += this.sizePacketFormatIndicator(mqttProperty);
                    break;
                }
                case PUBLICATION_EXPIRY_INTERVAL: {
                    minBytes += this.sizeMessageExpiryInterval(mqttProperty);
                    break;
                }
                case CONTENT_TYPE: {
                    minBytes += this.sizeContentType(mqttProperty);
                    break;
                }
                case RESPONSE_TOPIC: {
                    minBytes += this.sizeResponseTopic(mqttProperty);
                    break;
                }
                case CORRELATION_DATA: {
                    minBytes += this.sizeCorrelationData(mqttProperty);
                    break;
                }
                case SUBSCRIPTION_IDENTIFIER: {
                    minBytes += this.sizeSubscriptionIdentifier(mqttProperty);
                    break;
                }
                case SESSION_EXPIRY_INTERVAL: {
                    userPropsBytes += this.sizeSessionExpiryInterval(mqttProperty);
                    break;
                }
                case ASSIGNED_CLIENT_IDENTIFIER: {
                    minBytes += this.sizeAssignedIdentifier(mqttProperty);
                    break;
                }
                case SERVER_KEEP_ALIVE: {
                    minBytes += this.sizeServerKeepAlive(mqttProperty);
                    break;
                }
                case AUTHENTICATION_METHOD: {
                    minBytes += this.sizeAuthMethod(mqttProperty);
                    break;
                }
                case AUTHENTICATION_DATA: {
                    minBytes += this.sizeAuthData(mqttProperty);
                    break;
                }
                case REQUEST_PROBLEM_INFORMATION: {
                    minBytes += this.sizeRequestProblemInformation(mqttProperty);
                    break;
                }
                case WILL_DELAY_INTERVAL: {
                    minBytes += this.sizeWillDelayInterval(mqttProperty);
                    break;
                }
                case REQUEST_RESPONSE_INFORMATION: {
                    minBytes += this.sizeRequestResponseInformation(mqttProperty);
                    break;
                }
                case RESPONSE_INFORMATION: {
                    minBytes += this.sizeResponseInformaiton(mqttProperty);
                    break;
                }
                case SERVER_REFERENCE: {
                    minBytes += this.sizeServerReference(mqttProperty);
                    break;
                }
                case REASON_STRING: {
                    reasonStringBytes += this.sizeReasonStringProp(mqttProperty);
                    break;
                }
                case RECEIVE_MAXIMUM: {
                    minBytes += this.sizeReceiveMaximum(mqttProperty);
                    break;
                }
                case TOPIC_ALIAS_MAXIMUM: {
                    minBytes += this.sizeTopicAliasMaximum(mqttProperty);
                    break;
                }
                case TOPIC_ALIAS: {
                    minBytes += this.sizeTopicAlias(mqttProperty);
                    break;
                }
                case MAXIMUM_QOS: {
                    minBytes += this.sizeMaximumQoS(mqttProperty);
                    break;
                }
                case RETAIN_AVAILABLE: {
                    minBytes += this.sizeRetainAvailable(mqttProperty);
                    break;
                }
                case USER_PROPERTY: {
                    userPropsBytes += this.sizeUserProp(mqttProperty);
                    break;
                }
                case MAXIMUM_PACKET_SIZE: {
                    minBytes += this.sizeMaximumPacketSize(mqttProperty);
                    break;
                }
                case WILDCARD_SUBSCRIPTION_AVAILABLE: {
                    minBytes += this.sizeWildcardSubscriptionAvailable(mqttProperty);
                    break;
                }
                case SUBSCRIPTION_IDENTIFIER_AVAILABLE: {
                    minBytes += this.sizeSubscriptionIdentifierAvailable(mqttProperty);
                    break;
                }
                case SHARED_SUBSCRIPTION_AVAILABLE: {
                    minBytes += this.sizeSharedSubscriptionAvailable(mqttProperty);
                }
            }
        }
        return new MqttPropertiesBytes(IMQTTMessageSizer.varIntBytes(minBytes) + minBytes, reasonStringBytes, userPropsBytes);
    }

    private <T> int sizePacketFormatIndicator(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 2;
    }

    private <T> int sizeMessageExpiryInterval(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 5;
    }

    private <T> int sizeContentType(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.StringProperty);
        return 1 + ByteBufUtil.utf8Bytes((CharSequence)((CharSequence)((MqttProperties.StringProperty)mqttProp).value()));
    }

    private <T> int sizeResponseTopic(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.StringProperty);
        return 1 + ByteBufUtil.utf8Bytes((CharSequence)((CharSequence)((MqttProperties.StringProperty)mqttProp).value()));
    }

    private <T> int sizeCorrelationData(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.BinaryProperty);
        return 1 + IMQTTMessageSizer.sizeBinary((byte[])((MqttProperties.BinaryProperty)mqttProp).value());
    }

    private <T> int sizeSubscriptionIdentifier(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 1 + IMQTTMessageSizer.varIntBytes((Integer)((MqttProperties.IntegerProperty)mqttProp).value());
    }

    private <T> int sizeSessionExpiryInterval(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 5;
    }

    private <T> int sizeAssignedIdentifier(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.StringProperty);
        return 1 + ByteBufUtil.utf8Bytes((CharSequence)((CharSequence)((MqttProperties.StringProperty)mqttProp).value()));
    }

    private <T> int sizeServerKeepAlive(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 3;
    }

    private <T> int sizeAuthMethod(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.StringProperty);
        return 1 + IMQTTMessageSizer.sizeUTF8EncodedString((String)mqttProp.value());
    }

    private <T> int sizeAuthData(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.BinaryProperty);
        return 1 + IMQTTMessageSizer.sizeBinary((byte[])((MqttProperties.BinaryProperty)mqttProp).value());
    }

    private <T> int sizeRequestProblemInformation(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 2;
    }

    private <T> int sizeWillDelayInterval(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 5;
    }

    private <T> int sizeRequestResponseInformation(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 2;
    }

    private <T> int sizeResponseInformaiton(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.StringProperty);
        return 1 + ByteBufUtil.utf8Bytes((CharSequence)((CharSequence)((MqttProperties.StringProperty)mqttProp).value()));
    }

    private <T> int sizeServerReference(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.StringProperty);
        return 1 + ByteBufUtil.utf8Bytes((CharSequence)((CharSequence)((MqttProperties.StringProperty)mqttProp).value()));
    }

    private <T> int sizeReasonStringProp(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.StringProperty);
        return 1 + IMQTTMessageSizer.sizeUTF8EncodedString((String)mqttProp.value());
    }

    private <T> int sizeReceiveMaximum(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 3;
    }

    private <T> int sizeTopicAliasMaximum(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 3;
    }

    private <T> int sizeTopicAlias(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 3;
    }

    private <T> int sizeMaximumQoS(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 2;
    }

    private <T> int sizeRetainAvailable(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 2;
    }

    private <T> int sizeMaximumPacketSize(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 5;
    }

    private <T> int sizeWildcardSubscriptionAvailable(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 2;
    }

    private <T> int sizeSubscriptionIdentifierAvailable(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 2;
    }

    private <T> int sizeSharedSubscriptionAvailable(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.IntegerProperty);
        return 2;
    }

    private <T> int sizeUserProp(MqttProperties.MqttProperty<T> mqttProp) {
        assert (mqttProp instanceof MqttProperties.UserProperties);
        int totalBytes = 0;
        for (MqttProperties.StringPair pair : (List)((MqttProperties.UserProperties)mqttProp).value()) {
            ++totalBytes;
            totalBytes += IMQTTMessageSizer.sizeUTF8EncodedString(pair.key);
            totalBytes += IMQTTMessageSizer.sizeUTF8EncodedString(pair.value);
        }
        return totalBytes;
    }

    @Generated
    private MQTT5MessageSizer() {
    }

    private record MqttMessageSize(MqttVarHeaderBytes varHeaderBytes, int payloadBytes) implements IMQTTMessageSizer.MqttMessageSize
    {
        @Override
        public int encodedBytes() {
            return this.encodedBytes(true, true);
        }

        @Override
        public int encodedBytes(boolean includeUserProps, boolean includeReasonString) {
            if (this.varHeaderBytes == null) {
                return 2;
            }
            int totalVarHeaderBytes = this.varHeaderBytes.minBytes;
            if (includeUserProps) {
                totalVarHeaderBytes += this.varHeaderBytes.userPropsBytes;
            }
            if (includeReasonString) {
                totalVarHeaderBytes += this.varHeaderBytes.reasonStringBytes;
            }
            return 1 + IMQTTMessageSizer.varIntBytes(totalVarHeaderBytes + this.payloadBytes) + totalVarHeaderBytes + this.payloadBytes;
        }
    }

    private record MqttVarHeaderBytes(int minBytes, int reasonStringBytes, int userPropsBytes) {
    }

    private record MqttPropertiesBytes(int minBytes, int reasonStringBytes, int userPropsBytes) {
    }
}

