/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store;

import com.google.protobuf.Struct;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.store.option.KVRangeStoreOptions;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.inbox.store.IInboxStore;
import org.apache.bifromq.inbox.store.InboxStore;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.sysprops.props.InboxMetaCacheExpirySeconds;
import org.apache.bifromq.sysprops.props.PersistentSessionDetachTimeoutSecond;

public class InboxStoreBuilder {
    String clusterId = "inbox.store";
    RPCServerBuilder rpcServerBuilder;
    IAgentHost agentHost;
    IBaseKVMetaService metaService;
    IInboxClient inboxClient;
    IDistClient distClient;
    IRetainClient retainClient;
    ISessionDictClient sessionDictClient;
    IBaseKVStoreClient inboxStoreClient;
    ISettingProvider settingProvider;
    IEventCollector eventCollector;
    IResourceThrottler resourceThrottler;
    KVRangeStoreOptions storeOptions;
    int workerThreads;
    int tickerThreads;
    ScheduledExecutorService bgTaskExecutor;
    Duration bootstrapDelay = Duration.ofSeconds(15L);
    Duration zombieProbeDelay = Duration.ofSeconds(15L);
    Duration balancerRetryDelay = Duration.ofSeconds(5L);
    Map<String, Struct> balancerFactoryConfig = new HashMap<String, Struct>();
    Duration detachTimeout = Duration.ofSeconds(((Integer)PersistentSessionDetachTimeoutSecond.INSTANCE.get()).intValue());
    Duration metaCacheExpireTime = Duration.ofSeconds(((Integer)InboxMetaCacheExpirySeconds.INSTANCE.get()).intValue());
    int expireRateLimit = 1000;
    Duration minGCInterval = Duration.ofMinutes(5L);
    Duration maxGCInterval = Duration.ofHours(24L);
    Map<String, String> attributes = new HashMap<String, String>();

    public IInboxStore build() {
        return new InboxStore(this);
    }

    @Generated
    InboxStoreBuilder() {
    }

    @Generated
    public InboxStoreBuilder clusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    @Generated
    public InboxStoreBuilder rpcServerBuilder(RPCServerBuilder rpcServerBuilder) {
        this.rpcServerBuilder = rpcServerBuilder;
        return this;
    }

    @Generated
    public InboxStoreBuilder agentHost(IAgentHost agentHost) {
        this.agentHost = agentHost;
        return this;
    }

    @Generated
    public InboxStoreBuilder metaService(IBaseKVMetaService metaService) {
        this.metaService = metaService;
        return this;
    }

    @Generated
    public InboxStoreBuilder inboxClient(IInboxClient inboxClient) {
        this.inboxClient = inboxClient;
        return this;
    }

    @Generated
    public InboxStoreBuilder distClient(IDistClient distClient) {
        this.distClient = distClient;
        return this;
    }

    @Generated
    public InboxStoreBuilder retainClient(IRetainClient retainClient) {
        this.retainClient = retainClient;
        return this;
    }

    @Generated
    public InboxStoreBuilder sessionDictClient(ISessionDictClient sessionDictClient) {
        this.sessionDictClient = sessionDictClient;
        return this;
    }

    @Generated
    public InboxStoreBuilder inboxStoreClient(IBaseKVStoreClient inboxStoreClient) {
        this.inboxStoreClient = inboxStoreClient;
        return this;
    }

    @Generated
    public InboxStoreBuilder settingProvider(ISettingProvider settingProvider) {
        this.settingProvider = settingProvider;
        return this;
    }

    @Generated
    public InboxStoreBuilder eventCollector(IEventCollector eventCollector) {
        this.eventCollector = eventCollector;
        return this;
    }

    @Generated
    public InboxStoreBuilder resourceThrottler(IResourceThrottler resourceThrottler) {
        this.resourceThrottler = resourceThrottler;
        return this;
    }

    @Generated
    public InboxStoreBuilder storeOptions(KVRangeStoreOptions storeOptions) {
        this.storeOptions = storeOptions;
        return this;
    }

    @Generated
    public InboxStoreBuilder workerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    @Generated
    public InboxStoreBuilder tickerThreads(int tickerThreads) {
        this.tickerThreads = tickerThreads;
        return this;
    }

    @Generated
    public InboxStoreBuilder bgTaskExecutor(ScheduledExecutorService bgTaskExecutor) {
        this.bgTaskExecutor = bgTaskExecutor;
        return this;
    }

    @Generated
    public InboxStoreBuilder bootstrapDelay(Duration bootstrapDelay) {
        this.bootstrapDelay = bootstrapDelay;
        return this;
    }

    @Generated
    public InboxStoreBuilder zombieProbeDelay(Duration zombieProbeDelay) {
        this.zombieProbeDelay = zombieProbeDelay;
        return this;
    }

    @Generated
    public InboxStoreBuilder balancerRetryDelay(Duration balancerRetryDelay) {
        this.balancerRetryDelay = balancerRetryDelay;
        return this;
    }

    @Generated
    public InboxStoreBuilder balancerFactoryConfig(Map<String, Struct> balancerFactoryConfig) {
        this.balancerFactoryConfig = balancerFactoryConfig;
        return this;
    }

    @Generated
    public InboxStoreBuilder detachTimeout(Duration detachTimeout) {
        this.detachTimeout = detachTimeout;
        return this;
    }

    @Generated
    public InboxStoreBuilder metaCacheExpireTime(Duration metaCacheExpireTime) {
        this.metaCacheExpireTime = metaCacheExpireTime;
        return this;
    }

    @Generated
    public InboxStoreBuilder expireRateLimit(int expireRateLimit) {
        this.expireRateLimit = expireRateLimit;
        return this;
    }

    @Generated
    public InboxStoreBuilder minGCInterval(Duration minGCInterval) {
        this.minGCInterval = minGCInterval;
        return this;
    }

    @Generated
    public InboxStoreBuilder maxGCInterval(Duration maxGCInterval) {
        this.maxGCInterval = maxGCInterval;
        return this;
    }

    @Generated
    public InboxStoreBuilder attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }
}

