/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baseenv;

import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.bifromq.baseenv.IEnvProvider;
import org.apache.bifromq.basehookloader.BaseHookLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnvProvider
implements IEnvProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvProvider.class);
    public static final IEnvProvider INSTANCE;

    public int availableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public ThreadFactory newThreadFactory(final String name, final boolean daemon, final int priority) {
        return new ThreadFactory(){
            private final AtomicInteger seq = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                int s = this.seq.getAndIncrement();
                t.setName((String)(s > 0 ? name + "-" + s : name));
                t.setDaemon(daemon);
                t.setPriority(priority);
                return t;
            }
        };
    }

    @Generated
    EnvProvider() {
    }

    static {
        Map envProviderMap = BaseHookLoader.load(IEnvProvider.class);
        if (envProviderMap.isEmpty()) {
            log.info("No custom env provider found, fallback to default behavior");
            INSTANCE = new EnvProvider();
        } else {
            Map.Entry firstFound = (Map.Entry)envProviderMap.entrySet().stream().findFirst().get();
            log.info("Custom env provider is loaded: {}", firstFound.getKey());
            INSTANCE = (IEnvProvider)firstFound.getValue();
        }
    }
}

