---
id: 'become-committer'
title: 'Become A Committer'
---

Anyone being supportive of the community and working in any of the CoPDoC areas can become an Apache Fesod (Incubating) committer. The CoPDoC is an acronym from ASF to describe how we recognize your contributions not only by code.

- **(Co)mmunity** - You can join us via our mailing list, issue
  trackers, discussions page to interact with community members, and
  share vision and knowledge
- **(P)roject** - a clear vision and consensus are needed
- **(Do)cumentation** - without it, the stuff remains only in the minds
  of the authors
- **(C)ode** - discussion goes nowhere without code

Apache Fesod (Incubating) community strives to be meritocratic. Thus, once someone has contributed sufficiently to any area of CoPDoC they can be a candidate for committer-ship and at last voted in as an Apache Fesod (Incubating) committer. Being an Apache Fesod (Incubating) committer does not necessarily mean you must commit code with your commit privilege to the codebase, it means you are committed to the Apache Fesod (Incubating) project and are productively contributing to our community's success.

## Committer requirements

There are no strict rules for becoming a committer or PPMC member.
Candidates for new committers are typically people that are active
contributors and community members. Anyway, if the rules can be
clarified a little bit, it can somehow clear the doubts in the minds
of contributors and make the community more transparent, reasonable,
and fair.

### Continuous contributions

Committer candidates should have a decent amount of continuous
engagements and contributions (fixing bugs, adding new features,
writing documentation, maintaining issues boards, code review, or answering
community questions) to Apache Fesod (Incubating).

### Quality of contributions

- A solid general understanding of the project
- Well tested, well-designed, following Apache Fesod (Incubating) coding
  standards, and simple patches.
- Well-organized and detailed user-oriented documentation.

### Community involvement

- Be active, courteous, and respectful on the dev mailing list and
  help mentor newer contributors
  and users.
- Be active, courteous, and respectful on the issue tracker for
  project maintenance
- Be active, courteous, and respectful for pull requests reviewing
- Be involved in the design road map discussions with a professional
  and diplomatic approach even if there is a disagreement
- Promoting the project by writing articles or holding events

## Routine

- Check the list of pull requests and issues to be processed in the community on a daily basis.
  - Including label issue, reply issue, close issue;
  - Assign issue to the appropriate committer, namely assignee;
- After a committer is assigned with an issue, the following work is required:
  - Estimate whether it is a long-term issue. If it is, please label it as pending;
  - Add issue labels, such as bug, enhancement, discussion, etc;
  - Add milestone.
- Pull request that committer submits needs to add labels and milestone based on the type and release period.
- When committer reviewed and approved any pull request, committer could `squash and merge` to main branch. If there is any question you concerned about this pull request, please reply directly to the related issue.

## Benefits

Every Apache Committer is eligible for a free license that grants them access to all the JetBrains IDEs such as IntelliJ IDEA, PyCharm, and other desktop tools.

If you are an Apache Fesod (Incubating) Committer and still haven’t received a free JetBrains license, please use your `@apache.org` email address to [All Products Packs for Apache committers](https://www.jetbrains.com/shop/eform/apache?product=ALL) now for the subsequent development of Apache Fesod (Incubating).

If you have obtained a free JetBrains subscription but it has expired, you can reactivate all product packs for free using your `@apache.org` email address by this link and click `Refresh license list` in your JetBrains desktop tools (e.g. IntelliJ IDEA) to refresh the subscription.
