/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ReadBuffer {
    private final ReentrantLock lock = new ReentrantLock();
    private Condition readyCondition = this.lock.newCondition();
    private byte[] buffer;
    private STATUS status;
    private long byteStart;
    private long byteEnd;

    public ReadBuffer(long byteStart, long byteEnd) {
        this.buffer = new byte[(int)(byteEnd - byteStart) + 1];
        this.status = STATUS.INIT;
        this.byteStart = byteStart;
        this.byteEnd = byteEnd;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void await(STATUS waitStatus) throws InterruptedException {
        while (this.status == waitStatus) {
            this.readyCondition.await();
        }
    }

    public void signalAll() {
        this.readyCondition.signalAll();
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void setStatus(STATUS status) {
        this.status = status;
    }

    public long getByteStart() {
        return this.byteStart;
    }

    public long getByteEnd() {
        return this.byteEnd;
    }

    static enum STATUS {
        INIT,
        SUCCESS,
        ERROR;

    }
}

